/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.ow2.chameleon.core.services.Deployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryMonitor
implements BundleActivator,
ServiceTrackerCustomizer {
    protected final Logger logger;
    protected final List<Deployer> deployers = new ArrayList<Deployer>();
    private final File directory;
    private final long polling;
    private FileAlterationMonitor monitor;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ServiceTracker tracker;
    private BundleContext context;

    public DirectoryMonitor(File directory, long polling) {
        this.directory = directory;
        this.polling = polling;
        this.logger = LoggerFactory.getLogger((String)(DirectoryMonitor.class.getName() + "[" + directory.getName() + "]"));
        if (!directory.isDirectory()) {
            this.logger.info("Monitored directory {} not existing - creating directory", (Object)directory.getAbsolutePath());
            this.directory.mkdirs();
        }
        FileAlterationObserver observer = new FileAlterationObserver(directory, (FileFilter)TrueFileFilter.INSTANCE);
        observer.addListener((FileAlterationListener)new FileMonitor());
        this.monitor = new FileAlterationMonitor(polling, new FileAlterationObserver[]{observer});
    }

    public DirectoryMonitor(File directory) {
        this(directory, -1L);
    }

    public boolean acquireWriteLockIfNotHeld() {
        if (!this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().lock();
            return true;
        }
        return false;
    }

    public boolean releaseWriteLockIfHeld() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().unlock();
        }
        return this.lock.getWriteHoldCount() == 0;
    }

    public boolean acquireReadLockIfNotHeld() {
        if (this.lock.getReadHoldCount() == 0) {
            this.lock.readLock().lock();
            return true;
        }
        return false;
    }

    public boolean releaseReadLockIfHeld() {
        if (this.lock.getReadHoldCount() != 0) {
            this.lock.readLock().unlock();
        }
        return this.lock.getReadHoldCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.logger.info("Starting installing bundles from {}", (Object)this.directory.getAbsolutePath());
        this.tracker = new ServiceTracker(context, Deployer.class.getName(), (ServiceTrackerCustomizer)this);
        try {
            this.acquireWriteLockIfNotHeld();
            this.tracker.open();
            this.startFileMonitoring();
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
        try {
            this.acquireReadLockIfNotHeld();
            Collection files = FileUtils.listFiles((File)this.directory, null, (boolean)true);
            for (File file : files) {
                for (Deployer deployer : this.deployers) {
                    if (!deployer.accept(file)) continue;
                    deployer.open(files);
                }
            }
        }
        finally {
            this.releaseReadLockIfHeld();
        }
    }

    private void startFileMonitoring() throws Exception {
        if (this.polling == -1L) {
            this.logger.debug("No file monitoring for {}", (Object)this.directory.getAbsolutePath());
            return;
        }
        this.logger.info("Starting file monitoring for {} - polling : {} ms", (Object)this.directory.getName(), (Object)this.polling);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        block6: {
            try {
                this.acquireWriteLockIfNotHeld();
                this.tracker.close();
                if (this.monitor == null) break block6;
                this.logger.debug("Stopping file monitoring of {}", (Object)this.directory.getAbsolutePath());
                try {
                    this.monitor.stop(5L);
                }
                catch (IllegalStateException e) {
                    this.logger.warn("Stopping an already stopped file monitor on " + this.directory.getAbsolutePath());
                }
                this.monitor = null;
            }
            finally {
                this.releaseWriteLockIfHeld();
            }
        }
        for (Deployer deployer : this.deployers) {
            deployer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object addingService(ServiceReference reference) {
        Deployer deployer = (Deployer)this.context.getService(reference);
        try {
            this.acquireWriteLockIfNotHeld();
            this.deployers.add(deployer);
            Collection files = FileUtils.listFiles((File)this.directory, null, (boolean)true);
            ArrayList<File> accepted = new ArrayList<File>();
            for (File file : files) {
                if (!deployer.accept(file)) continue;
                accepted.add(file);
            }
            deployer.open(accepted);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
        return deployer;
    }

    public void modifiedService(ServiceReference reference, Object o) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedService(ServiceReference reference, Object o) {
        Deployer deployer = (Deployer)o;
        try {
            this.acquireWriteLockIfNotHeld();
            this.deployers.remove(deployer);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    private class FileMonitor
    extends FileAlterationListenerAdaptor {
        private FileMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFileCreate(File file) {
            DirectoryMonitor.this.logger.info("File " + file + " created in " + DirectoryMonitor.this.directory);
            ArrayList<Deployer> depl = new ArrayList<Deployer>();
            try {
                DirectoryMonitor.this.acquireReadLockIfNotHeld();
                for (Deployer deployer : DirectoryMonitor.this.deployers) {
                    if (!deployer.accept(file)) continue;
                    depl.add(deployer);
                }
            }
            finally {
                DirectoryMonitor.this.releaseReadLockIfHeld();
            }
            DirectoryMonitor.this.logger.debug("Deployer handling creation of " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileCreate(file);
                }
                catch (Throwable e) {
                    DirectoryMonitor.this.logger.error("Error during the management of {} (created) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFileChange(File file) {
            DirectoryMonitor.this.logger.info("File " + file + " from " + DirectoryMonitor.this.directory + " changed");
            ArrayList<Deployer> depl = new ArrayList<Deployer>();
            try {
                DirectoryMonitor.this.acquireReadLockIfNotHeld();
                for (Deployer deployer : DirectoryMonitor.this.deployers) {
                    if (!deployer.accept(file)) continue;
                    depl.add(deployer);
                }
            }
            finally {
                DirectoryMonitor.this.releaseReadLockIfHeld();
            }
            DirectoryMonitor.this.logger.debug("Deployers handling change in " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileChange(file);
                }
                catch (Throwable e) {
                    DirectoryMonitor.this.logger.error("Error during the management of {} (change) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFileDelete(File file) {
            DirectoryMonitor.this.logger.info("File " + file + " deleted from " + DirectoryMonitor.this.directory);
            ArrayList<Deployer> depl = new ArrayList<Deployer>();
            try {
                DirectoryMonitor.this.acquireReadLockIfNotHeld();
                for (Deployer deployer : DirectoryMonitor.this.deployers) {
                    if (!deployer.accept(file)) continue;
                    depl.add(deployer);
                }
            }
            finally {
                DirectoryMonitor.this.releaseReadLockIfHeld();
            }
            DirectoryMonitor.this.logger.debug("Deployer handling deletion of " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileDelete(file);
                }
                catch (Throwable e) {
                    DirectoryMonitor.this.logger.error("Error during the management of {} (delete) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }
    }
}

