/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.ow2.chameleon.core.Chameleon;

public class Main {
    private Main() {
    }

    public static void main(String[] args) {
        Chameleon chameleon = null;
        try {
            chameleon = Main.createChameleon(args);
        }
        catch (Exception e) {
            System.err.println("Cannot initialize Chameleon : " + e.getMessage());
            e.printStackTrace();
        }
        if (chameleon == null) {
            return;
        }
        Main.registerShutdownHook(chameleon);
        try {
            chameleon.start();
        }
        catch (Exception e) {
            System.err.println("Cannot start Chameleon : " + e.getMessage());
        }
    }

    public static Chameleon createChameleon(String[] args) throws Exception {
        boolean interactive = Main.isInteractiveModeEnabled(args);
        Map<String, Object> map = Main.parseUserProperties(args);
        return new Chameleon(interactive, map);
    }

    public static Map<String, Object> parseUserProperties(String[] args) {
        if (args == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String arg : args) {
            if (!arg.startsWith("-D")) continue;
            if ((arg = arg.substring(2)).contains("=")) {
                String k = arg.substring(0, arg.indexOf("="));
                String v = arg.substring(arg.indexOf("=") + 1);
                map.put(k, v);
                continue;
            }
            map.put(arg, Boolean.TRUE);
        }
        return map;
    }

    private static void registerShutdownHook(final Chameleon chameleon) {
        Runtime runtime = Runtime.getRuntime();
        Runnable hook = new Runnable(){

            @Override
            public void run() {
                try {
                    if (chameleon != null) {
                        chameleon.stop();
                    }
                }
                catch (Exception e) {
                    System.err.println("Cannot stop Chameleon correctly : " + e.getMessage());
                }
            }
        };
        runtime.addShutdownHook(new Thread(hook));
    }

    private static boolean isInteractiveModeEnabled(String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("--interactive")) continue;
            return true;
        }
        return false;
    }
}

