/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.ow2.chameleon.core.utils.BundleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreActivator
implements BundleActivator {
    private final boolean interactive;
    private final File directory;
    private final Logger logger;
    private BundleContext context;

    public CoreActivator(File directory, boolean interactive) {
        this.directory = directory;
        this.interactive = interactive;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void installBundles() {
        Collection files = FileUtils.listFiles((File)this.directory, (String[])new String[]{"jar"}, (boolean)true);
        ArrayList<Bundle> toStart = new ArrayList<Bundle>();
        for (File file : files) {
            if (!BundleHelper.isBundle(file) || this.isInteractiveShell(file) && !this.interactive) continue;
            try {
                this.logger.debug("Installing bundle from {}", (Object)file.getAbsolutePath());
                Bundle bundle = this.context.installBundle("reference:" + file.toURI().toURL().toExternalForm());
                if (BundleHelper.isFragment(bundle)) continue;
                toStart.add(bundle);
            }
            catch (Exception e) {
                this.logger.error("Error when install bundle from {}", new Object[]{file.getAbsolutePath(), e});
            }
        }
        for (Bundle bundle : toStart) {
            try {
                this.logger.debug("Starting bundle {}", (Object)bundle.getSymbolicName());
                bundle.start();
            }
            catch (BundleException e) {
                this.logger.error("Error when start bundle {}", new Object[]{bundle.getSymbolicName(), e});
            }
        }
    }

    private boolean isInteractiveShell(File file) {
        return file.getName().startsWith("shelbie-startup-console");
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.installBundles();
    }

    public void stop(BundleContext context) throws Exception {
    }
}

