/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogActivator
implements LogListener,
BundleActivator,
ServiceListener {
    private final Logger logger;
    private ServiceReference logService;
    private BundleContext context;

    public LogActivator(Logger logger) {
        this.logger = logger;
    }

    ServiceReference getLogServiceReference() {
        return this.logService;
    }

    public void setLogServiceReference(ServiceReference ref) {
        this.logService = ref;
    }

    public void logged(LogEntry le) {
        String message = le.getMessage();
        Logger thelogger = this.logger;
        if (le.getBundle() != null) {
            thelogger = LoggerFactory.getLogger((String)le.getBundle().getSymbolicName());
        }
        if (le.getServiceReference() != null) {
            message = le.getServiceReference().getProperty("service.pid") != null ? message + " [ServicePID=" + le.getServiceReference().getProperty("service.pid") + "]" : message + " [ServiceID=" + le.getServiceReference().getProperty("service.id") + "]";
        }
        switch (le.getLevel()) {
            case 4: {
                if (le.getException() != null) {
                    thelogger.debug(message, le.getException());
                    break;
                }
                thelogger.debug(message);
                break;
            }
            case 3: {
                if (le.getException() != null) {
                    thelogger.info(message, le.getException());
                    break;
                }
                thelogger.info(message);
                break;
            }
            case 2: {
                if (le.getException() != null) {
                    thelogger.warn(message, le.getException());
                    break;
                }
                thelogger.warn(message);
                break;
            }
            case 1: {
                if (le.getException() != null) {
                    thelogger.error(message, le.getException());
                    break;
                }
                thelogger.error(message);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        this.context = bc;
        LogActivator logActivator = this;
        synchronized (logActivator) {
            this.context.addServiceListener((ServiceListener)this, "(objectClass=" + LogReaderService.class.getName() + ")");
            this.logService = this.context.getServiceReference(LogReaderService.class.getName());
            if (this.logService != null) {
                LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
                reader.addLogListener((LogListener)this);
            }
        }
    }

    public void stop(BundleContext bc) throws Exception {
        if (bc != null) {
            bc.removeServiceListener((ServiceListener)this);
            if (this.logService != null) {
                LogReaderService reader = (LogReaderService)bc.getService(this.logService);
                reader.removeLogListener((LogListener)this);
                this.logService = null;
            }
        }
    }

    public synchronized void serviceChanged(ServiceEvent ev) {
        if (this.logService == null && ev.getType() == 1) {
            this.logService = ev.getServiceReference();
            LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
            reader.addLogListener((LogListener)this);
            return;
        }
        if (this.logService != null && ev.getType() == 4 && this.logService == ev.getServiceReference()) {
            LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
            reader.removeLogListener((LogListener)this);
            this.logService = null;
        }
    }
}

