/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.converter;

import java.util.Formatter;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.service.command.Converter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
public class ServiceReferenceConverter
implements Converter,
Pojo {
    private InstanceManager __IM;
    private boolean __FsupportedClasses;
    @ServiceProperty(name="osgi.converter.classes", value="org.osgi.framework.ServiceReference")
    private String supportedClasses;
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __Mconvert$java_lang_Class$java_lang_Object;
    private boolean __Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter;
    private boolean __Mprint$org_osgi_framework_ServiceReference;
    private boolean __MgetShortNames$java_lang_String__;
    private boolean __MgetShortName$java_lang_String;

    String __getsupportedClasses() {
        if (!this.__FsupportedClasses) {
            return this.supportedClasses;
        }
        return (String)this.__IM.onGet((Object)this, "supportedClasses");
    }

    void __setsupportedClasses(String string) {
        if (!this.__FsupportedClasses) {
            this.supportedClasses = string;
            return;
        }
        this.__IM.onSet((Object)this, "supportedClasses", (Object)string);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    public ServiceReferenceConverter(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ServiceReferenceConverter(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setcontext(context);
    }

    public Object convert(Class<?> desiredType, Object in) throws Exception {
        Object object;
        if (!this.__Mconvert$java_lang_Class$java_lang_Object) {
            return this.__M_convert(desiredType, in);
        }
        try {
            this.__IM.onEntry((Object)this, "convert$java_lang_Class$java_lang_Object", new Object[]{desiredType, in});
            object = this.__M_convert(desiredType, in);
            this.__IM.onExit((Object)this, "convert$java_lang_Class$java_lang_Object", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convert$java_lang_Class$java_lang_Object", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_convert(Class<?> desiredType, Object in) throws Exception {
        if (ServiceReference.class.equals(desiredType)) {
            String s = in.toString();
            if (s.startsWith("(") && s.endsWith(")")) {
                ServiceReference[] refs = this.__getcontext().getServiceReferences(null, s);
                if (refs != null) {
                    return refs[0];
                }
            } else {
                String filter = String.format("(|(service.id=%s)(service.pid=%s))", in, in);
                ServiceReference[] refs = this.__getcontext().getServiceReferences(null, filter);
                if (refs != null) {
                    return refs[0];
                }
            }
            return null;
        }
        return null;
    }

    public CharSequence format(Object target, int level, Converter converter) throws Exception {
        CharSequence charSequence;
        if (!this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter) {
            return this.__M_format(target, level, converter);
        }
        try {
            this.__IM.onEntry((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", new Object[]{target, new Integer(level), converter});
            charSequence = this.__M_format(target, level, converter);
            this.__IM.onExit((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_format(Object target, int level, Converter converter) throws Exception {
        if (level == 1 && target instanceof ServiceReference) {
            return this.print((ServiceReference)target);
        }
        if (level == 2 && target instanceof ServiceReference) {
            return this.getShortNames((String[])((ServiceReference)target).getProperty("objectclass"));
        }
        return null;
    }

    private CharSequence print(ServiceReference ref) {
        CharSequence charSequence;
        if (!this.__Mprint$org_osgi_framework_ServiceReference) {
            return this.__M_print(ref);
        }
        try {
            this.__IM.onEntry((Object)this, "print$org_osgi_framework_ServiceReference", new Object[]{ref});
            charSequence = this.__M_print(ref);
            this.__IM.onExit((Object)this, "print$org_osgi_framework_ServiceReference", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "print$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_print(ServiceReference ref) {
        StringBuilder sb = new StringBuilder();
        Formatter f = new Formatter(sb);
        String spid = "";
        Object pid = ref.getProperty("service.pid");
        if (pid != null) {
            spid = pid.toString();
        }
        f.format("%06d %3s %-40s %s", ref.getProperty("service.id"), ref.getBundle().getBundleId(), this.getShortNames((String[])ref.getProperty("objectclass")), spid);
        return sb;
    }

    protected CharSequence getShortNames(String[] list) {
        CharSequence charSequence;
        if (!this.__MgetShortNames$java_lang_String__) {
            return this.__M_getShortNames(list);
        }
        try {
            this.__IM.onEntry((Object)this, "getShortNames$java_lang_String__", new Object[]{list});
            charSequence = this.__M_getShortNames(list);
            this.__IM.onExit((Object)this, "getShortNames$java_lang_String__", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getShortNames$java_lang_String__", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_getShortNames(String[] list) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (String s : list) {
            sb.append(del + this.getShortName(s));
            del = " | ";
        }
        return sb;
    }

    protected CharSequence getShortName(String name) {
        CharSequence charSequence;
        if (!this.__MgetShortName$java_lang_String) {
            return this.__M_getShortName(name);
        }
        try {
            this.__IM.onEntry((Object)this, "getShortName$java_lang_String", new Object[]{name});
            charSequence = this.__M_getShortName(name);
            this.__IM.onExit((Object)this, "getShortName$java_lang_String", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getShortName$java_lang_String", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_getShortName(String name) {
        int n = name.lastIndexOf(46);
        n = n < 0 ? 0 : ++n;
        return name.subSequence(n, name.length());
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("supportedClasses")) {
                this.__FsupportedClasses = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("convert$java_lang_Class$java_lang_Object")) {
                this.__Mconvert$java_lang_Class$java_lang_Object = true;
            }
            if (set.contains("format$java_lang_Object$int$org_apache_felix_service_command_Converter")) {
                this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter = true;
            }
            if (set.contains("print$org_osgi_framework_ServiceReference")) {
                this.__Mprint$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("getShortNames$java_lang_String__")) {
                this.__MgetShortNames$java_lang_String__ = true;
            }
            if (set.contains("getShortName$java_lang_String")) {
                this.__MgetShortName$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

