/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jline.console.completer.Completer;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.basic.ActionPreparator;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.PrimitiveHandler;
import org.apache.felix.ipojo.annotations.Bind;
import org.apache.felix.ipojo.annotations.Handler;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.StaticServiceProperty;
import org.apache.felix.ipojo.annotations.Unbind;
import org.apache.felix.ipojo.annotations.Validate;
import org.apache.felix.ipojo.architecture.HandlerDescription;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.ow2.shelbie.core.ICompletable;
import org.ow2.shelbie.core.internal.handler.GogoCommand;
import org.ow2.shelbie.core.internal.handler.StatefulGogoCommand;
import org.ow2.shelbie.core.internal.handler.StatelessGogoCommand;
import org.ow2.shelbie.core.internal.handler.info.InfoBuilder;
import org.ow2.shelbie.core.registry.info.ScopeInfo;
import org.ow2.shelbie.core.registry.supply.InfoSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Handler(name="command", namespace="org.ow2.shelbie")
@Provides(specifications={Function.class, ICompletable.class, InfoSupplier.class}, properties={@StaticServiceProperty(name="type", value="shelbie", type="java.lang.String")})
public class CommandHandler
extends PrimitiveHandler
implements Function,
ICompletable,
InfoSupplier,
Pojo {
    private InstanceManager __IM;
    public static final String NAMESPACE = "org.ow2.shelbie";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String COMMAND_ELEMENT = "command";
    private boolean __Ftype;
    private Type type;
    private boolean __Fcommand;
    private GogoCommand command;
    private boolean __Fpreparator;
    private ActionPreparator preparator;
    private boolean __Fcompleters;
    private List<Completer> completers;
    private boolean __Fscope;
    @ServiceProperty(name="osgi.command.scope")
    private String scope;
    private boolean __Ffunction;
    @ServiceProperty(name="osgi.command.function")
    private String function;
    private boolean __FcommandId;
    private String commandId;
    private boolean __Finfo;
    private ScopeInfo info;
    private boolean __Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary;
    private boolean __MbindActionPreparator$org_apache_felix_gogo_commands_basic_ActionPreparator;
    private boolean __MbindCompleter$jline_console_completer_Completer$java_util_Map;
    private boolean __MunbindCompleter$jline_console_completer_Completer;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession$java_util_List;
    private boolean __MgetCompleters;
    private boolean __Mstart;
    private boolean __MbuildScopeInfo$java_lang_Class;
    private boolean __Mvalidate;
    private boolean __Minvalidate;
    private boolean __Mstop;
    private boolean __MgetScopeInfo;
    private boolean __MgetDescription;

    Type __gettype() {
        if (!this.__Ftype) {
            return this.type;
        }
        return (Type)((Object)this.__IM.onGet((Object)this, TYPE_ATTRIBUTE));
    }

    void __settype(Type type) {
        if (!this.__Ftype) {
            this.type = type;
            return;
        }
        this.__IM.onSet((Object)this, TYPE_ATTRIBUTE, (Object)type);
    }

    GogoCommand __getcommand() {
        if (!this.__Fcommand) {
            return this.command;
        }
        return (GogoCommand)this.__IM.onGet((Object)this, COMMAND_ELEMENT);
    }

    void __setcommand(GogoCommand gogoCommand) {
        if (!this.__Fcommand) {
            this.command = gogoCommand;
            return;
        }
        this.__IM.onSet((Object)this, COMMAND_ELEMENT, (Object)gogoCommand);
    }

    ActionPreparator __getpreparator() {
        if (!this.__Fpreparator) {
            return this.preparator;
        }
        return (ActionPreparator)this.__IM.onGet((Object)this, "preparator");
    }

    void __setpreparator(ActionPreparator actionPreparator) {
        if (!this.__Fpreparator) {
            this.preparator = actionPreparator;
            return;
        }
        this.__IM.onSet((Object)this, "preparator", (Object)actionPreparator);
    }

    List __getcompleters() {
        if (!this.__Fcompleters) {
            return this.completers;
        }
        return (List)this.__IM.onGet((Object)this, "completers");
    }

    void __setcompleters(List list) {
        if (!this.__Fcompleters) {
            this.completers = list;
            return;
        }
        this.__IM.onSet((Object)this, "completers", (Object)list);
    }

    String __getscope() {
        if (!this.__Fscope) {
            return this.scope;
        }
        return (String)this.__IM.onGet((Object)this, "scope");
    }

    void __setscope(String string) {
        if (!this.__Fscope) {
            this.scope = string;
            return;
        }
        this.__IM.onSet((Object)this, "scope", (Object)string);
    }

    String __getfunction() {
        if (!this.__Ffunction) {
            return this.function;
        }
        return (String)this.__IM.onGet((Object)this, "function");
    }

    void __setfunction(String string) {
        if (!this.__Ffunction) {
            this.function = string;
            return;
        }
        this.__IM.onSet((Object)this, "function", (Object)string);
    }

    String __getcommandId() {
        if (!this.__FcommandId) {
            return this.commandId;
        }
        return (String)this.__IM.onGet((Object)this, "commandId");
    }

    void __setcommandId(String string) {
        if (!this.__FcommandId) {
            this.commandId = string;
            return;
        }
        this.__IM.onSet((Object)this, "commandId", (Object)string);
    }

    ScopeInfo __getinfo() {
        if (!this.__Finfo) {
            return this.info;
        }
        return (ScopeInfo)this.__IM.onGet((Object)this, "info");
    }

    void __setinfo(ScopeInfo scopeInfo) {
        if (!this.__Finfo) {
            this.info = scopeInfo;
            return;
        }
        this.__IM.onSet((Object)this, "info", (Object)scopeInfo);
    }

    public CommandHandler() {
        this(null);
    }

    private CommandHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__settype(Type.STATELESS);
    }

    public void configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary) {
            this.__M_configure(element, dictionary);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", new Object[]{element, dictionary});
            this.__M_configure(element, dictionary);
            this.__IM.onExit((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary", throwable);
            throw throwable;
        }
    }

    private void __M_configure(Element element, Dictionary dictionary) throws ConfigurationException {
        if (!element.containsElement(COMMAND_ELEMENT, NAMESPACE)) {
            throw new ConfigurationException("Missing 'command' element.");
        }
        Element commandElement = element.getElements(COMMAND_ELEMENT, NAMESPACE)[0];
        String typeAttr = commandElement.getAttribute(TYPE_ATTRIBUTE, NAMESPACE);
        if (typeAttr != null) {
            try {
                this.__settype(Type.valueOf(typeAttr.toUpperCase()));
            }
            catch (IllegalArgumentException iae) {
                throw new ConfigurationException("Invalid value for 'type' attribute ('stateless' or 'stateful' only are permitted).");
            }
        }
        this.__setcompleters(new ArrayList());
        this.__setcommandId((String)dictionary.get("instance.name"));
    }

    public void bindActionPreparator(ActionPreparator preparator) {
        if (!this.__MbindActionPreparator$org_apache_felix_gogo_commands_basic_ActionPreparator) {
            this.__M_bindActionPreparator(preparator);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindActionPreparator$org_apache_felix_gogo_commands_basic_ActionPreparator", new Object[]{preparator});
            this.__M_bindActionPreparator(preparator);
            this.__IM.onExit((Object)this, "bindActionPreparator$org_apache_felix_gogo_commands_basic_ActionPreparator", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindActionPreparator$org_apache_felix_gogo_commands_basic_ActionPreparator", throwable);
            throw throwable;
        }
    }

    @Bind
    private void __M_bindActionPreparator(ActionPreparator preparator) {
        this.__setpreparator(preparator);
    }

    public void bindCompleter(Completer completer, Map reference) {
        if (!this.__MbindCompleter$jline_console_completer_Completer$java_util_Map) {
            this.__M_bindCompleter(completer, reference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindCompleter$jline_console_completer_Completer$java_util_Map", new Object[]{completer, reference});
            this.__M_bindCompleter(completer, reference);
            this.__IM.onExit((Object)this, "bindCompleter$jline_console_completer_Completer$java_util_Map", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindCompleter$jline_console_completer_Completer$java_util_Map", throwable);
            throw throwable;
        }
    }

    @Bind(optional=true, aggregate=true, filter="(command.id=*)")
    private void __M_bindCompleter(Completer completer, Map reference) {
        if (this.__getcommandId().equals(reference.get("command.id"))) {
            this.__getcompleters().add(completer);
        }
    }

    public void unbindCompleter(Completer completer) {
        if (!this.__MunbindCompleter$jline_console_completer_Completer) {
            this.__M_unbindCompleter(completer);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindCompleter$jline_console_completer_Completer", new Object[]{completer});
            this.__M_unbindCompleter(completer);
            this.__IM.onExit((Object)this, "unbindCompleter$jline_console_completer_Completer", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindCompleter$jline_console_completer_Completer", throwable);
            throw throwable;
        }
    }

    @Unbind
    private void __M_unbindCompleter(Completer completer) {
        this.__getcompleters().remove(completer);
    }

    public Object execute(CommandSession commandSession, List<Object> objects) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession$java_util_List) {
            return this.__M_execute(commandSession, objects);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession$java_util_List", new Object[]{commandSession, objects});
            object = this.__M_execute(commandSession, objects);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession$java_util_List", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession$java_util_List", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession commandSession, List<Object> objects) throws Exception {
        if (this.__getcommand() != null) {
            return this.__getcommand().execute(commandSession, objects);
        }
        System.err.println(String.format("Shelbie command %s:%s is not ready to be executed", this.__getscope(), this.__getfunction()));
        return null;
    }

    @Override
    public List<Completer> getCompleters() {
        List<Completer> list;
        if (!this.__MgetCompleters) {
            return this.__M_getCompleters();
        }
        try {
            this.__IM.onEntry((Object)this, "getCompleters", new Object[0]);
            list = this.__M_getCompleters();
            this.__IM.onExit((Object)this, "getCompleters", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCompleters", throwable);
            throw throwable;
        }
        return list;
    }

    private List<Completer> __M_getCompleters() {
        return this.__getcompleters();
    }

    public void start() {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    private void __M_start() {
        Class actionClass = this.getInstanceManager().getClazz();
        if (!Action.class.isAssignableFrom(actionClass)) {
            throw new IllegalArgumentException("The Component is not inheriting from the Action interface!");
        }
        Command cmd = actionClass.getAnnotation(Command.class);
        if (cmd == null) {
            throw new IllegalArgumentException("Action class is not annotated with @Command");
        }
        this.__setscope(cmd.scope());
        this.__setfunction(cmd.name());
        this.__setinfo(this.buildScopeInfo(actionClass));
    }

    private ScopeInfo buildScopeInfo(Class<?> actionClass) {
        ScopeInfo scopeInfo;
        if (!this.__MbuildScopeInfo$java_lang_Class) {
            return this.__M_buildScopeInfo(actionClass);
        }
        try {
            this.__IM.onEntry((Object)this, "buildScopeInfo$java_lang_Class", new Object[]{actionClass});
            scopeInfo = this.__M_buildScopeInfo(actionClass);
            this.__IM.onExit((Object)this, "buildScopeInfo$java_lang_Class", (Object)scopeInfo);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "buildScopeInfo$java_lang_Class", throwable);
            throw throwable;
        }
        return scopeInfo;
    }

    private ScopeInfo __M_buildScopeInfo(Class<?> actionClass) {
        return new InfoBuilder().buildScope(actionClass);
    }

    public void validate() {
        if (!this.__Mvalidate) {
            this.__M_validate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "validate", new Object[0]);
            this.__M_validate();
            this.__IM.onExit((Object)this, "validate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "validate", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __M_validate() {
        switch (this.__gettype()) {
            case STATEFUL: {
                this.__setcommand(new StatefulGogoCommand(this.getInstanceManager(), this.__getpreparator()));
                break;
            }
            case STATELESS: {
                this.__setcommand(new StatelessGogoCommand(this.getInstanceManager(), this.__getpreparator()));
            }
        }
    }

    public void invalidate() {
        if (!this.__Minvalidate) {
            this.__M_invalidate();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "invalidate", new Object[0]);
            this.__M_invalidate();
            this.__IM.onExit((Object)this, "invalidate", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "invalidate", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_invalidate() {
        if (this.__getcommand() != null) {
            this.__getcommand().release();
        }
        this.__setcommand(null);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    private void __M_stop() {
        this.__setscope(null);
        this.__setfunction(null);
    }

    @Override
    public Collection<ScopeInfo> getScopeInfo() {
        Collection<ScopeInfo> collection;
        if (!this.__MgetScopeInfo) {
            return this.__M_getScopeInfo();
        }
        try {
            this.__IM.onEntry((Object)this, "getScopeInfo", new Object[0]);
            collection = this.__M_getScopeInfo();
            this.__IM.onExit((Object)this, "getScopeInfo", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getScopeInfo", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<ScopeInfo> __M_getScopeInfo() {
        return Collections.singletonList(this.__getinfo());
    }

    public HandlerDescription getDescription() {
        HandlerDescription handlerDescription;
        if (!this.__MgetDescription) {
            return this.__M_getDescription();
        }
        try {
            this.__IM.onEntry((Object)this, "getDescription", new Object[0]);
            handlerDescription = this.__M_getDescription();
            this.__IM.onExit((Object)this, "getDescription", (Object)handlerDescription);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDescription", throwable);
            throw throwable;
        }
        return handlerDescription;
    }

    private HandlerDescription __M_getDescription() {
        return new HandlerDescription((org.apache.felix.ipojo.Handler)this){

            public Element getHandlerInfo() {
                Element info = super.getHandlerInfo();
                Element command = new Element(CommandHandler.COMMAND_ELEMENT, "");
                command.addAttribute(new Attribute("scope", CommandHandler.this.__getscope()));
                command.addAttribute(new Attribute("name", CommandHandler.this.__getfunction()));
                command.addAttribute(new Attribute(CommandHandler.TYPE_ATTRIBUTE, CommandHandler.this.__gettype().name().toLowerCase()));
                info.addElement(command);
                return info;
            }
        };
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains(COMMAND_ELEMENT)) {
                this.__Fcommand = true;
            }
            if (set.contains("commandId")) {
                this.__FcommandId = true;
            }
            if (set.contains("completers")) {
                this.__Fcompleters = true;
            }
            if (set.contains("function")) {
                this.__Ffunction = true;
            }
            if (set.contains("info")) {
                this.__Finfo = true;
            }
            if (set.contains("preparator")) {
                this.__Fpreparator = true;
            }
            if (set.contains("scope")) {
                this.__Fscope = true;
            }
            if (set.contains(TYPE_ATTRIBUTE)) {
                this.__Ftype = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("configure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary")) {
                this.__Mconfigure$org_apache_felix_ipojo_metadata_Element$java_util_Dictionary = true;
            }
            if (set.contains("bindActionPreparator$org_apache_felix_gogo_commands_basic_ActionPreparator")) {
                this.__MbindActionPreparator$org_apache_felix_gogo_commands_basic_ActionPreparator = true;
            }
            if (set.contains("bindCompleter$jline_console_completer_Completer$java_util_Map")) {
                this.__MbindCompleter$jline_console_completer_Completer$java_util_Map = true;
            }
            if (set.contains("unbindCompleter$jline_console_completer_Completer")) {
                this.__MunbindCompleter$jline_console_completer_Completer = true;
            }
            if (set.contains("execute$org_apache_felix_service_command_CommandSession$java_util_List")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession$java_util_List = true;
            }
            if (set.contains("getCompleters")) {
                this.__MgetCompleters = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("buildScopeInfo$java_lang_Class")) {
                this.__MbuildScopeInfo$java_lang_Class = true;
            }
            if (set.contains("validate")) {
                this.__Mvalidate = true;
            }
            if (set.contains("invalidate")) {
                this.__Minvalidate = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("getScopeInfo")) {
                this.__MgetScopeInfo = true;
            }
            if (set.contains("getDescription")) {
                this.__MgetDescription = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        STATELESS,
        STATEFUL;

    }
}

