/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.handler.info;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.ow2.shelbie.core.internal.handler.info.DefaultArgumentInfo;
import org.ow2.shelbie.core.internal.handler.info.DefaultCommandInfo;
import org.ow2.shelbie.core.internal.handler.info.DefaultOptionInfo;
import org.ow2.shelbie.core.internal.handler.info.DefaultScopeInfo;
import org.ow2.shelbie.core.registry.info.ArgumentInfo;
import org.ow2.shelbie.core.registry.info.OptionInfo;
import org.ow2.shelbie.core.registry.info.ScopeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoBuilder {
    public ScopeInfo buildScope(Class<?> actionClass) {
        Command cmd = actionClass.getAnnotation(Command.class);
        DefaultCommandInfo dci = new DefaultCommandInfo(cmd.scope(), cmd.name(), cmd.description());
        DefaultScopeInfo dsi = new DefaultScopeInfo(cmd.scope(), dci);
        for (Field field : actionClass.getDeclaredFields()) {
            Argument arg;
            Option option = field.getAnnotation(Option.class);
            if (option != null) {
                dci.addOption(this.buildOptionInfo(option, field));
            }
            if ((arg = field.getAnnotation(Argument.class)) == null) continue;
            dci.addArgument(this.buildArgumentInfo(arg, field));
        }
        return dsi;
    }

    private ArgumentInfo buildArgumentInfo(Argument arg, Field field) {
        DefaultArgumentInfo info = new DefaultArgumentInfo(arg.index(), field.getType());
        info.setRequired(arg.required());
        info.setMultiValued(arg.multiValued());
        info.setDescription(arg.description());
        return info;
    }

    private OptionInfo buildOptionInfo(Option option, Field field) {
        DefaultOptionInfo info = new DefaultOptionInfo(this.getNames(option), field.getType());
        info.setRequired(option.required());
        info.setMultiValued(option.multiValued());
        info.setDescription(option.description());
        return info;
    }

    private List<String> getNames(Option option) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(option.name());
        names.addAll(Arrays.asList(option.aliases()));
        return names;
    }
}

