/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.registry.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class References {
    public static String getCommandScope(ServiceReference reference) {
        Object value = reference.getProperty("osgi.command.scope");
        if (value == null) {
            throw new NullPointerException("Missing 'osgi.command.scope' property in reference");
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Property '" + value + "' is not a String");
        }
        return (String)value;
    }

    public static List<String> getCommandFunctions(ServiceReference reference) {
        Object value = reference.getProperty("osgi.command.function");
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        if (value.getClass().isArray() && String.class.equals(value.getClass().getComponentType())) {
            return Arrays.asList((String[])value);
        }
        throw new IllegalArgumentException("Property '" + value + "' is neither a String not a String[]");
    }
}

