/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.utils;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.Bundle;
import org.slf4j.LoggerFactory;

public class BundleHelper {
    public static final String BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";

    private BundleHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBundle(File file) {
        if (file.isFile() && file.getName().endsWith(".jar")) {
            JarFile finalJar;
            boolean bl;
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                bl = jar.getManifest() != null && jar.getManifest().getMainAttributes() != null && jar.getManifest().getMainAttributes().getValue(BUNDLE_MANIFEST_VERSION) != null;
                finalJar = jar;
            }
            catch (IOException e) {
                JarFile finalJar2;
                boolean bl2;
                try {
                    LoggerFactory.getLogger(BundleHelper.class).error("Cannot check if the file {} is a bundle, cannot open it", (Object)file.getName(), (Object)e);
                    bl2 = false;
                    finalJar2 = jar;
                }
                catch (Throwable throwable) {
                    JarFile finalJar3 = jar;
                    IOUtils.closeQuietly((Closeable)new Closeable(finalJar3){
                        final /* synthetic */ JarFile val$finalJar;
                        {
                            this.val$finalJar = jarFile;
                        }

                        @Override
                        public void close() throws IOException {
                            if (this.val$finalJar != null) {
                                this.val$finalJar.close();
                            }
                        }
                    });
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)new /* invalid duplicate definition of identical inner class */);
                return bl2;
            }
            IOUtils.closeQuietly((Closeable)new /* invalid duplicate definition of identical inner class */);
            return bl;
        }
        return file.isDirectory() && BundleHelper.isExplodedBundle(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isExplodedBundle(File directory) {
        boolean bl;
        File manifestFile = new File(directory, "META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            return false;
        }
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(manifestFile);
            Manifest manifest = new Manifest(stream);
            bl = manifest.getMainAttributes().getValue(BUNDLE_MANIFEST_VERSION) != null;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                LoggerFactory.getLogger(BundleHelper.class).error("Cannot check if the directory {} is a bundle, cannot read the manifest file", (Object)directory.getName(), (Object)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
            return bl2;
        }
        IOUtils.closeQuietly((InputStream)stream);
        return bl;
    }

    public static boolean isFragment(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        return headers.get("Fragment-Host") != null;
    }
}

