/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.ow2.chameleon.core.services.Deployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryMonitor
implements BundleActivator,
ServiceTrackerCustomizer<Deployer, Deployer> {
    protected final Logger logger;
    protected final List<Deployer> deployers = new ArrayList<Deployer>();
    private final File directory;
    private final long polling;
    private FileAlterationMonitor monitor;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ServiceTracker<Deployer, Deployer> tracker;
    private BundleContext context;

    public DirectoryMonitor(File directory, long polling) {
        this.directory = directory;
        this.polling = polling;
        this.logger = LoggerFactory.getLogger((String)(DirectoryMonitor.class.getName() + "[" + directory.getName() + "]"));
        if (polling == -1L) {
            return;
        }
        if (!directory.isDirectory()) {
            this.logger.info("Monitored directory {} not existing - creating directory", (Object)directory.getAbsolutePath());
            boolean created = this.directory.mkdirs();
            this.logger.debug("Monitored direction {} creation ? {}", (Object)directory.getAbsolutePath(), (Object)created);
        }
        FileAlterationObserver observer = new FileAlterationObserver(directory, (FileFilter)TrueFileFilter.INSTANCE);
        observer.addListener((FileAlterationListener)new FileMonitor());
        this.logger.debug("Creating file alteration monitor for " + directory.getAbsolutePath() + " with a polling period " + "of " + polling);
        this.monitor = new FileAlterationMonitor(polling, new FileAlterationObserver[]{observer});
    }

    public DirectoryMonitor(File directory) {
        this(directory, -1L);
    }

    public boolean acquireWriteLockIfNotHeld() {
        if (!this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().lock();
            return true;
        }
        return false;
    }

    public boolean releaseWriteLockIfHeld() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().unlock();
        }
        return this.lock.getWriteHoldCount() == 0;
    }

    public boolean acquireReadLockIfNotHeld() {
        if (this.lock.getReadHoldCount() == 0) {
            this.lock.readLock().lock();
            return true;
        }
        return false;
    }

    public boolean releaseReadLockIfHeld() {
        if (this.lock.getReadHoldCount() != 0) {
            this.lock.readLock().unlock();
        }
        return this.lock.getReadHoldCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(BundleContext context) throws IOException {
        this.context = context;
        this.logger.info("Starting installing resources from {}", (Object)this.directory.getAbsolutePath());
        this.tracker = new ServiceTracker<Deployer, Deployer>(context, Deployer.class.getName(), this);
        try {
            this.acquireWriteLockIfNotHeld();
            this.tracker.open();
            this.startFileMonitoring();
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    private List<File> getAcceptedFilesByTheDeployer(Collection<File> files, Deployer deployer) {
        ArrayList<File> accepted = new ArrayList<File>();
        for (File file : files) {
            if (!deployer.accept(file)) continue;
            accepted.add(file);
        }
        return accepted;
    }

    private void startFileMonitoring() throws IOException {
        if (this.polling == -1L) {
            this.logger.debug("No file monitoring for {}", (Object)this.directory.getAbsolutePath());
            return;
        }
        this.logger.info("Starting file monitoring for {} - polling : {} ms", (Object)this.directory.getName(), (Object)this.polling);
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            throw new IOException("Cannot start the monitoring of " + this.directory.getAbsolutePath(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(BundleContext context) {
        block7: {
            try {
                this.acquireWriteLockIfNotHeld();
                this.tracker.close();
                if (this.monitor == null) break block7;
                this.logger.debug("Stopping file monitoring of {}", (Object)this.directory.getAbsolutePath());
                try {
                    this.monitor.stop();
                    this.logger.debug("File monitoring stopped");
                }
                catch (IllegalStateException e) {
                    this.logger.warn("Stopping an already stopped file monitor on " + this.directory.getAbsolutePath());
                    this.logger.debug(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    this.logger.error("Something bad happened while trying to stop the file monitor", (Throwable)e);
                }
                this.monitor = null;
            }
            finally {
                this.releaseWriteLockIfHeld();
            }
        }
        for (Deployer deployer : this.deployers) {
            deployer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deployer addingService(ServiceReference<Deployer> reference) {
        Deployer deployer = this.context.getService(reference);
        try {
            this.acquireWriteLockIfNotHeld();
            this.deployers.add(deployer);
            Collection files = FileUtils.listFiles((File)this.directory, null, (boolean)true);
            List<File> accepted = this.getAcceptedFilesByTheDeployer(files, deployer);
            this.logger.info("Opening deployer {} for directory {}.", (Object)deployer, (Object)this.directory.getAbsolutePath());
            deployer.open(accepted);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
        return deployer;
    }

    @Override
    public void modifiedService(ServiceReference<Deployer> reference, Deployer o) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removedService(ServiceReference<Deployer> reference, Deployer deployer) {
        try {
            this.acquireWriteLockIfNotHeld();
            this.deployers.remove(deployer);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Deployer> getDeployersAcceptingFile(File file) {
        ArrayList<Deployer> depl = new ArrayList<Deployer>();
        try {
            this.acquireReadLockIfNotHeld();
            for (Deployer deployer : this.deployers) {
                if (!deployer.accept(file)) continue;
                depl.add(deployer);
            }
        }
        finally {
            this.releaseReadLockIfHeld();
        }
        return depl;
    }

    private class FileMonitor
    extends FileAlterationListenerAdaptor {
        private FileMonitor() {
        }

        public void onFileCreate(File file) {
            DirectoryMonitor.this.logger.info("File " + file + " created in " + DirectoryMonitor.this.directory);
            List depl = DirectoryMonitor.this.getDeployersAcceptingFile(file);
            DirectoryMonitor.this.logger.debug("Deployer handling creation of " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileCreate(file);
                }
                catch (Exception e) {
                    DirectoryMonitor.this.logger.error("Error during the management of {} (creation) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }

        public void onFileChange(File file) {
            DirectoryMonitor.this.logger.info("File " + file + " from " + DirectoryMonitor.this.directory + " changed");
            List depl = DirectoryMonitor.this.getDeployersAcceptingFile(file);
            DirectoryMonitor.this.logger.debug("Deployers handling change in " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileChange(file);
                }
                catch (Exception e) {
                    DirectoryMonitor.this.logger.error("Error during the management of {} (change) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }

        public void onFileDelete(File file) {
            DirectoryMonitor.this.logger.info("File " + file + " deleted from " + DirectoryMonitor.this.directory);
            List depl = DirectoryMonitor.this.getDeployersAcceptingFile(file);
            DirectoryMonitor.this.logger.debug("Deployer handling deletion of " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileDelete(file);
                }
                catch (Exception e) {
                    DirectoryMonitor.this.logger.error("Error during the management of {} (deletion) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }
    }
}

