/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.builtin.internal;

import java.util.Set;
import jline.console.history.History;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.service.command.CommandSession;

@Command(name="history", scope="shelbie", description="Manage the session's history.")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class HistoryAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Fclear;
    @Option(name="-c", aliases={"--clear"}, description="Causes the history list to be cleared by deleting all of the entries.")
    private boolean clear;
    private boolean __Fdelete;
    @Option(name="-d", aliases={"--delete"}, description="Deletes the history entry at the given offset.")
    private int delete;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;

    boolean __getclear() {
        if (!this.__Fclear) {
            return this.clear;
        }
        Object object = this.__IM.onGet((Object)this, "clear");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setclear(boolean bl) {
        if (!this.__Fclear) {
            this.clear = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "clear", (Object)bl2);
    }

    int __getdelete() {
        if (!this.__Fdelete) {
            return this.delete;
        }
        Object object = this.__IM.onGet((Object)this, "delete");
        Integer n = (Integer)object;
        return n;
    }

    void __setdelete(int n) {
        if (!this.__Fdelete) {
            this.delete = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "delete", (Object)n2);
    }

    public HistoryAction() {
        this(null);
    }

    private HistoryAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setclear(false);
        this.__setdelete(-1);
    }

    public Object execute(CommandSession session) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(session);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{session});
            object = this.__M_execute(session);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        History history = (History)session.get(History.class.getName());
        if (history == null || history.isEmpty()) {
            return null;
        }
        if (this.__getclear()) {
            history.clear();
            return null;
        }
        if (this.__getdelete() != -1) {
            if (this.__getdelete() >= history.size()) {
                System.err.printf("Deletion index: %d is out of bounds (current size:%d)%n", this.__getdelete(), history.size());
                return null;
            }
            System.out.printf("Deleted entry %d - %s%n", this.__getdelete(), history.remove(this.__getdelete()));
            return null;
        }
        for (History.Entry entry : history) {
            System.out.printf("%6d  %s%n", entry.index(), entry.value());
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("clear")) {
                this.__Fclear = true;
            }
            if (set.contains("delete")) {
                this.__Fdelete = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null && set.contains("execute$org_apache_felix_service_command_CommandSession")) {
            this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

