/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ipojo.internal;

import java.io.PrintStream;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;
import org.ow2.shelbie.commands.ipojo.internal.util.AnsiPrintToolkit;

@Command(name="factory", scope="ipojo", description="Display information about one given Component Factory")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class FactoryAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Ffactories;
    @Requires(optional=true)
    private Factory[] factories;
    private boolean __Fverbose;
    @Option(name="-v", aliases={"--verbose"}, description="When activated, display additional Factory information.")
    private boolean verbose;
    private boolean __Fname;
    @Argument(name="factory-name", required=true, description="A given Component Factory name")
    private String name;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __MprintFactoryDetails$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_Factory;

    Factory[] __getfactories() {
        if (!this.__Ffactories) {
            return this.factories;
        }
        return (Factory[])this.__IM.onGet((Object)this, "factories");
    }

    void __setfactories(Factory[] factoryArray) {
        if (!this.__Ffactories) {
            this.factories = factoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "factories", (Object)factoryArray);
    }

    boolean __getverbose() {
        if (!this.__Fverbose) {
            return this.verbose;
        }
        Object object = this.__IM.onGet((Object)this, "verbose");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setverbose(boolean bl) {
        if (!this.__Fverbose) {
            this.verbose = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "verbose", (Object)bl2);
    }

    String __getname() {
        if (!this.__Fname) {
            return this.name;
        }
        return (String)this.__IM.onGet((Object)this, "name");
    }

    void __setname(String string) {
        if (!this.__Fname) {
            this.name = string;
            return;
        }
        this.__IM.onSet((Object)this, "name", (Object)string);
    }

    public FactoryAction() {
        this(null);
    }

    private FactoryAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setverbose(false);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        Ansi buffer = Ansi.ansi();
        boolean found = false;
        for (Factory factory : this.__getfactories()) {
            if (!this.__getname().equals(factory.getName())) continue;
            this.printFactoryDetails(buffer, factory);
            found = true;
        }
        PrintStream stream = System.out;
        if (!found) {
            stream = System.err;
            buffer.a(" [");
            buffer.a((Object)Ansi.Color.RED);
            buffer.a("ERROR");
            buffer.reset();
            buffer.a("] ");
            buffer.a("Factory '");
            buffer.a(Ansi.Attribute.ITALIC);
            buffer.a(this.__getname());
            buffer.a(Ansi.Attribute.ITALIC_OFF);
            buffer.a("' was not found.\n");
        }
        stream.println(buffer.toString());
        return null;
    }

    private void printFactoryDetails(Ansi ansi, Factory factory) {
        if (!this.__MprintFactoryDetails$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_Factory) {
            this.__M_printFactoryDetails(ansi, factory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printFactoryDetails$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_Factory", new Object[]{ansi, factory});
            this.__M_printFactoryDetails(ansi, factory);
            this.__IM.onExit((Object)this, "printFactoryDetails$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_Factory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printFactoryDetails$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_Factory", throwable);
            throw throwable;
        }
    }

    private void __M_printFactoryDetails(Ansi buffer, Factory factory) {
        String status = "INVALID";
        Ansi.Color color = Ansi.Color.RED;
        if (factory.getState() == 1) {
            status = "VALID";
            color = Ansi.Color.GREEN;
        }
        buffer.a(factory.getName());
        buffer.a(" ");
        buffer.a("[");
        buffer.fg(color);
        buffer.a(status);
        buffer.reset();
        buffer.a("]\n");
        AnsiPrintToolkit toolkit = new AnsiPrintToolkit(buffer);
        toolkit.printElement(0, factory.getDescription());
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("factories")) {
                this.__Ffactories = true;
            }
            if (set.contains("name")) {
                this.__Fname = true;
            }
            if (set.contains("verbose")) {
                this.__Fverbose = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("printFactoryDetails$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_Factory")) {
                this.__MprintFactoryDetails$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_Factory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

