/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.console.startup;

import java.io.File;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.security.auth.Subject;
import jline.TerminalFactory;
import jline.console.completer.Completer;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.apache.felix.service.command.CommandProcessor;
import org.ow2.shelbie.core.branding.BrandingService;
import org.ow2.shelbie.core.console.JLineConsole;
import org.ow2.shelbie.core.console.OperatingSystem;
import org.ow2.shelbie.core.history.HistoryFileProvider;
import org.ow2.shelbie.core.internal.security.RolesPrincipal;
import org.ow2.shelbie.core.internal.security.UserPrincipal;
import org.ow2.shelbie.core.prompt.PromptService;
import org.ow2.shelbie.core.system.SystemService;

@Component
public class ConsoleStartupComponent
implements Pojo {
    private InstanceManager __IM;
    private boolean __Fprocessor;
    @Requires
    private CommandProcessor processor;
    private boolean __Fsystem;
    @Requires
    private SystemService system;
    private boolean __Fcompleter;
    @Requires(filter="(type=commands)")
    private Completer completer;
    private boolean __FpromptService;
    @Requires(policy="dynamic-priority")
    private PromptService promptService;
    private boolean __FhistoryProvider;
    @Requires(policy="dynamic-priority", optional=true, defaultimplementation=NullHistoryFileProvider.class)
    private HistoryFileProvider historyProvider;
    private boolean __FbrandingService;
    @Requires(optional=true, nullable=false, proxy=false)
    private BrandingService brandingService;
    private boolean __Fconsole;
    private JLineConsole console;
    private boolean __Mstartup;
    private boolean __McreateLocalSubject;
    private boolean __Mshutdown;

    CommandProcessor __getprocessor() {
        if (!this.__Fprocessor) {
            return this.processor;
        }
        return (CommandProcessor)this.__IM.onGet((Object)this, "processor");
    }

    void __setprocessor(CommandProcessor commandProcessor) {
        if (!this.__Fprocessor) {
            this.processor = commandProcessor;
            return;
        }
        this.__IM.onSet((Object)this, "processor", (Object)commandProcessor);
    }

    SystemService __getsystem() {
        if (!this.__Fsystem) {
            return this.system;
        }
        return (SystemService)this.__IM.onGet((Object)this, "system");
    }

    void __setsystem(SystemService systemService) {
        if (!this.__Fsystem) {
            this.system = systemService;
            return;
        }
        this.__IM.onSet((Object)this, "system", (Object)systemService);
    }

    Completer __getcompleter() {
        if (!this.__Fcompleter) {
            return this.completer;
        }
        return (Completer)this.__IM.onGet((Object)this, "completer");
    }

    void __setcompleter(Completer completer) {
        if (!this.__Fcompleter) {
            this.completer = completer;
            return;
        }
        this.__IM.onSet((Object)this, "completer", (Object)completer);
    }

    PromptService __getpromptService() {
        if (!this.__FpromptService) {
            return this.promptService;
        }
        return (PromptService)this.__IM.onGet((Object)this, "promptService");
    }

    void __setpromptService(PromptService promptService) {
        if (!this.__FpromptService) {
            this.promptService = promptService;
            return;
        }
        this.__IM.onSet((Object)this, "promptService", (Object)promptService);
    }

    HistoryFileProvider __gethistoryProvider() {
        if (!this.__FhistoryProvider) {
            return this.historyProvider;
        }
        return (HistoryFileProvider)this.__IM.onGet((Object)this, "historyProvider");
    }

    void __sethistoryProvider(HistoryFileProvider historyFileProvider) {
        if (!this.__FhistoryProvider) {
            this.historyProvider = historyFileProvider;
            return;
        }
        this.__IM.onSet((Object)this, "historyProvider", (Object)historyFileProvider);
    }

    BrandingService __getbrandingService() {
        if (!this.__FbrandingService) {
            return this.brandingService;
        }
        return (BrandingService)this.__IM.onGet((Object)this, "brandingService");
    }

    void __setbrandingService(BrandingService brandingService) {
        if (!this.__FbrandingService) {
            this.brandingService = brandingService;
            return;
        }
        this.__IM.onSet((Object)this, "brandingService", (Object)brandingService);
    }

    JLineConsole __getconsole() {
        if (!this.__Fconsole) {
            return this.console;
        }
        return (JLineConsole)this.__IM.onGet((Object)this, "console");
    }

    void __setconsole(JLineConsole jLineConsole) {
        if (!this.__Fconsole) {
            this.console = jLineConsole;
            return;
        }
        this.__IM.onSet((Object)this, "console", (Object)jLineConsole);
    }

    public ConsoleStartupComponent() {
        this(null);
    }

    private ConsoleStartupComponent(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void startup() throws Exception {
        if (!this.__Mstartup) {
            this.__M_startup();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "startup", new Object[0]);
            this.__M_startup();
            this.__IM.onExit((Object)this, "startup", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "startup", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    private void __M_startup() throws Exception {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ConsoleStartupComponent.class.getClassLoader());
        try {
            this.__setconsole(new JLineConsole(this.__getprocessor(), this.__getcompleter(), this.__getsystem().getIn(), this.__getsystem().getOut(), this.__getsystem().getErr(), TerminalFactory.get()));
            this.__getconsole().setCallback(new ShutdownCallback());
            Subject subject = this.createLocalSubject();
            this.__getconsole().setHistoryFile(this.__gethistoryProvider().getHistoryFile(subject));
            this.__getconsole().setPromptService(this.__getpromptService());
            this.__getconsole().setBrandingService(this.__getbrandingService());
            Thread thread = new Thread((Runnable)new PrivilegedRunnable(subject, this.__getconsole()), "Shelbie Console Thread");
            thread.setDaemon(true);
            thread.start();
            this.__getconsole().getSession().put("application.name", (Object)"shelbie");
            this.__getconsole().getSession().put(Subject.class.getName(), (Object)subject);
            OperatingSystem os = new OperatingSystem();
            os.setName(System.getProperty("os.name"));
            os.setArch(System.getProperty("os.arch"));
            os.setVersion(System.getProperty("os.version"));
            this.__getconsole().getSession().put("os", (Object)os);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    private Subject createLocalSubject() {
        Subject subject;
        if (!this.__McreateLocalSubject) {
            return this.__M_createLocalSubject();
        }
        try {
            this.__IM.onEntry((Object)this, "createLocalSubject", new Object[0]);
            subject = this.__M_createLocalSubject();
            this.__IM.onExit((Object)this, "createLocalSubject", (Object)subject);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createLocalSubject", throwable);
            throw throwable;
        }
        return subject;
    }

    private Subject __M_createLocalSubject() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new UserPrincipal(System.getProperty("user.name")));
        subject.getPrincipals().add((Principal)((Object)new RolesPrincipal("admin")));
        return subject;
    }

    public void shutdown() {
        if (!this.__Mshutdown) {
            this.__M_shutdown();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "shutdown", new Object[0]);
            this.__M_shutdown();
            this.__IM.onExit((Object)this, "shutdown", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "shutdown", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_shutdown() {
        this.__getconsole().close();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("brandingService")) {
                this.__FbrandingService = true;
            }
            if (set.contains("completer")) {
                this.__Fcompleter = true;
            }
            if (set.contains("console")) {
                this.__Fconsole = true;
            }
            if (set.contains("historyProvider")) {
                this.__FhistoryProvider = true;
            }
            if (set.contains("processor")) {
                this.__Fprocessor = true;
            }
            if (set.contains("promptService")) {
                this.__FpromptService = true;
            }
            if (set.contains("system")) {
                this.__Fsystem = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("startup")) {
                this.__Mstartup = true;
            }
            if (set.contains("createLocalSubject")) {
                this.__McreateLocalSubject = true;
            }
            if (set.contains("shutdown")) {
                this.__Mshutdown = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }

    private class ShutdownCallback
    implements Runnable {
        private ShutdownCallback() {
        }

        public void run() {
            if (!ConsoleStartupComponent.this.__getsystem().isStopping()) {
                try {
                    ConsoleStartupComponent.this.__getconsole().getSession().execute((CharSequence)"shelbie:shutdown --force --quiet");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static class PrivilegedRunnable
    implements Runnable {
        private final Subject subject;
        private final Runnable delegate;

        protected PrivilegedRunnable(Subject subject, Runnable delegate) {
            this.subject = subject;
            this.delegate = delegate;
        }

        public void run() {
            Subject.doAs(this.subject, new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    PrivilegedRunnable.this.delegate.run();
                    return true;
                }
            });
        }
    }

    public static class NullHistoryFileProvider
    implements HistoryFileProvider {
        public File getHistoryFile(Subject subject) {
            return null;
        }
    }
}

