/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.extension.parser;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.metadata.Element;
import org.ow2.shelbie.core.internal.extension.parser.MetadataUtils;
import org.ow2.shelbie.core.internal.extension.type.ECommand;
import org.ow2.shelbie.core.internal.extension.type.ECompleter;

public class CommandParser {
    public static final String ACTION = "action";
    public static final String COMPONENT = "component";
    public static final String PROPERTY = "property";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String VALUE = "value";
    public static final String ARRAY_TYPE = "array";
    public static final String VECTOR_TYPE = "vector";
    public static final String LIST_TYPE = "list";
    public static final String MAP_TYPE = "map";
    public static final String DICTIONARY_TYPE = "dictionary";
    public static final String COMPLETER = "completer";

    public ECommand getCommandDescription(Element metadata) throws ConfigurationException {
        ECommand type = new ECommand(MetadataUtils.getAttributeValue(metadata, ACTION));
        Element[] completers = metadata.getElements(COMPLETER, "org.ow2.shelbie");
        if (completers != null) {
            for (int i = 0; i < completers.length; ++i) {
                ECompleter completer = this.createCompleter(completers[i]);
                completer.addProperty("completer.position", String.valueOf(i));
                type.addCompleter(completer);
            }
        }
        return type;
    }

    private ECompleter createCompleter(Element element) throws ConfigurationException {
        ECompleter instance = new ECompleter(MetadataUtils.getAttributeValue(element, COMPONENT));
        Element[] properties = element.getElements(PROPERTY);
        if (properties != null) {
            for (Element prop : properties) {
                String name = MetadataUtils.getAttributeValue(prop, NAME);
                String type = MetadataUtils.getAttributeValue(prop, TYPE, false);
                if (type != null) {
                    if (ARRAY_TYPE.equals(type)) {
                        instance.addProperty(name, this.getArrayProperty(prop));
                        continue;
                    }
                    if (VECTOR_TYPE.equals(type)) {
                        instance.addProperty(name, this.getVectorProperty(prop));
                        continue;
                    }
                    if (LIST_TYPE.equals(type)) {
                        instance.addProperty(name, this.getListProperty(prop));
                        continue;
                    }
                    if (MAP_TYPE.equals(type)) {
                        instance.addProperty(name, this.getMapProperty(prop));
                        continue;
                    }
                    if (DICTIONARY_TYPE.equals(type)) {
                        instance.addProperty(name, this.getDictionaryProperty(prop));
                        continue;
                    }
                    throw new ConfigurationException("Unknown type '" + type + "' on element '" + prop.getName() + "'.");
                }
                NameValue nv = this.getSimpleProperty(prop);
                String value = nv.value.trim();
                if (value.startsWith("{") && value.endsWith("}")) {
                    value = value.substring(1);
                    value = value.substring(0, value.lastIndexOf(125));
                    instance.addProperty(name, value.split(","));
                    continue;
                }
                instance.addProperty(nv.name, nv.value);
            }
        }
        return instance;
    }

    private String[] getArrayProperty(Element element) throws ConfigurationException {
        String[] strings = new String[]{};
        Element[] properties = element.getElements(PROPERTY);
        if (properties != null) {
            strings = new String[properties.length];
            for (int i = 0; i < properties.length; ++i) {
                strings[i] = MetadataUtils.getAttributeValue(properties[i], VALUE);
            }
        }
        return strings;
    }

    private Vector getVectorProperty(Element element) throws ConfigurationException {
        Vector<String> vector = new Vector<String>();
        Element[] properties = element.getElements(PROPERTY);
        if (properties != null) {
            for (Element property : properties) {
                vector.add(MetadataUtils.getAttributeValue(property, VALUE));
            }
        }
        return vector;
    }

    private List getListProperty(Element element) throws ConfigurationException {
        ArrayList<String> list = new ArrayList<String>();
        Element[] properties = element.getElements(PROPERTY);
        if (properties != null) {
            for (Element property : properties) {
                list.add(MetadataUtils.getAttributeValue(property, VALUE));
            }
        }
        return list;
    }

    private Map getMapProperty(Element element) throws ConfigurationException {
        HashMap<String, String> map = new HashMap<String, String>();
        Element[] properties = element.getElements(PROPERTY);
        if (properties != null) {
            for (Element property : properties) {
                NameValue nv = this.getSimpleProperty(property);
                map.put(nv.name, nv.value);
            }
        }
        return map;
    }

    private Dictionary getDictionaryProperty(Element element) throws ConfigurationException {
        Hashtable<String, String> dictionary = new Hashtable<String, String>();
        Element[] properties = element.getElements(PROPERTY);
        if (properties != null) {
            for (Element property : properties) {
                NameValue nv = this.getSimpleProperty(property);
                ((Dictionary)dictionary).put(nv.name, nv.value);
            }
        }
        return dictionary;
    }

    private NameValue getSimpleProperty(Element element) throws ConfigurationException {
        NameValue property = new NameValue();
        property.name = MetadataUtils.getAttributeValue(element, NAME);
        property.value = MetadataUtils.getAttributeValue(element, VALUE);
        return property;
    }

    private static class NameValue {
        String name;
        String value;

        private NameValue() {
        }
    }
}

