/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.converter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.service.command.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
public class NumberConverter
implements Converter,
Pojo {
    private InstanceManager __IM;
    private boolean __FsupportedClasses;
    @ServiceProperty(name="osgi.converter.classes", value="java.lang.Number")
    private String supportedClasses;
    private boolean __Mconvert$java_lang_Class$java_lang_Object;
    private boolean __MconvertToNumber$java_lang_Number$java_lang_Class;
    private boolean __Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter;

    String __getsupportedClasses() {
        if (!this.__FsupportedClasses) {
            return this.supportedClasses;
        }
        return (String)this.__IM.onGet((Object)this, "supportedClasses");
    }

    void __setsupportedClasses(String string) {
        if (!this.__FsupportedClasses) {
            this.supportedClasses = string;
            return;
        }
        this.__IM.onSet((Object)this, "supportedClasses", (Object)string);
    }

    public NumberConverter() {
        this(null);
    }

    private NumberConverter(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public Object convert(Class<?> toType, Object in) throws Exception {
        Object object;
        if (!this.__Mconvert$java_lang_Class$java_lang_Object) {
            return this.__M_convert(toType, in);
        }
        try {
            this.__IM.onEntry((Object)this, "convert$java_lang_Class$java_lang_Object", new Object[]{toType, in});
            object = this.__M_convert(toType, in);
            this.__IM.onExit((Object)this, "convert$java_lang_Class$java_lang_Object", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convert$java_lang_Class$java_lang_Object", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_convert(Class<?> toType, Object in) throws Exception {
        if (in instanceof Number && Number.class.isAssignableFrom(toType)) {
            return this.convertToNumber((Number)in, toType);
        }
        return null;
    }

    private Object convertToNumber(Number value, Class toType) throws Exception {
        Object object;
        if (!this.__MconvertToNumber$java_lang_Number$java_lang_Class) {
            return this.__M_convertToNumber(value, toType);
        }
        try {
            this.__IM.onEntry((Object)this, "convertToNumber$java_lang_Number$java_lang_Class", new Object[]{value, toType});
            object = this.__M_convertToNumber(value, toType);
            this.__IM.onExit((Object)this, "convertToNumber$java_lang_Number$java_lang_Class", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convertToNumber$java_lang_Number$java_lang_Class", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_convertToNumber(Number value, Class toType) throws Exception {
        if (AtomicInteger.class.equals((Object)toType)) {
            return new AtomicInteger((Integer)this.convertToNumber(value, Integer.class));
        }
        if (AtomicLong.class.equals((Object)toType)) {
            return new AtomicLong((Long)this.convertToNumber(value, Long.class));
        }
        if (Integer.class.equals((Object)toType)) {
            return value.intValue();
        }
        if (Short.class.equals((Object)toType)) {
            return value.shortValue();
        }
        if (Long.class.equals((Object)toType)) {
            return value.longValue();
        }
        if (Float.class.equals((Object)toType)) {
            return Float.valueOf(value.floatValue());
        }
        if (Double.class.equals((Object)toType)) {
            return value.doubleValue();
        }
        if (Byte.class.equals((Object)toType)) {
            return value.byteValue();
        }
        if (BigInteger.class.equals((Object)toType)) {
            return new BigInteger(value.toString());
        }
        if (BigDecimal.class.equals((Object)toType)) {
            return new BigDecimal(value.toString());
        }
        return null;
    }

    public CharSequence format(Object o, int level, Converter converter) throws Exception {
        CharSequence charSequence;
        if (!this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter) {
            return this.__M_format(o, level, converter);
        }
        try {
            this.__IM.onEntry((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", new Object[]{o, new Integer(level), converter});
            charSequence = this.__M_format(o, level, converter);
            this.__IM.onExit((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", (Object)charSequence);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "format$java_lang_Object$int$org_apache_felix_service_command_Converter", throwable);
            throw throwable;
        }
        return charSequence;
    }

    private CharSequence __M_format(Object o, int level, Converter converter) throws Exception {
        if (o instanceof Number) {
            return o.toString();
        }
        return null;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null && set.contains("supportedClasses")) {
            this.__FsupportedClasses = true;
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("convert$java_lang_Class$java_lang_Object")) {
                this.__Mconvert$java_lang_Class$java_lang_Object = true;
            }
            if (set.contains("convertToNumber$java_lang_Number$java_lang_Class")) {
                this.__MconvertToNumber$java_lang_Number$java_lang_Class = true;
            }
            if (set.contains("format$java_lang_Object$int$org_apache_felix_service_command_Converter")) {
                this.__Mformat$java_lang_Object$int$org_apache_felix_service_command_Converter = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

