/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ipojo.internal.util;

import java.util.Arrays;
import java.util.List;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.fusesource.jansi.Ansi;

public class AnsiPrintToolkit {
    private static final String DEFAULT_INDENTER = "  ";
    public static final List<String> GOOD_STATES = Arrays.asList("valid", "resolved", "registered");
    private Ansi buffer;
    private boolean verbose = false;
    private String indenter = "  ";

    public AnsiPrintToolkit() {
        this(Ansi.ansi());
    }

    public AnsiPrintToolkit(Ansi ansi) {
        this.buffer = ansi;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Ansi getBuffer() {
        return this.buffer;
    }

    public String getIndenter() {
        return this.indenter;
    }

    public void setIndenter(String indenter) {
        this.indenter = indenter;
    }

    public void printElement(int level, Element element) {
        this.indent(level);
        this.buffer.a(Ansi.Attribute.INTENSITY_BOLD);
        String ns = element.getNameSpace();
        if (this.verbose && !AnsiPrintToolkit.isEmpty(ns)) {
            this.buffer.a(ns);
            this.buffer.a(":");
        }
        this.buffer.a(element.getName());
        this.buffer.a(Ansi.Attribute.INTENSITY_BOLD_OFF);
        if (element.getAttributes() != null) {
            for (Attribute attribute : element.getAttributes()) {
                this.printAttribute(attribute);
            }
        }
        if (element.getElements() != null) {
            for (Attribute attribute : element.getElements()) {
                this.eol();
                this.printElement(level + 1, (Element)attribute);
            }
        }
    }

    public void printAttribute(Attribute attribute) {
        this.buffer.a(" ");
        String ns = attribute.getNameSpace();
        if (this.verbose && !AnsiPrintToolkit.isEmpty(ns)) {
            this.buffer.a(ns);
            this.buffer.a(":");
        }
        this.buffer.a(attribute.getName());
        this.buffer.a("=\"");
        String value = attribute.getValue();
        if ("state".equals(attribute.getName())) {
            if (GOOD_STATES.contains(value)) {
                this.buffer.fg(Ansi.Color.GREEN);
            } else {
                this.buffer.fg(Ansi.Color.RED);
            }
        }
        this.buffer.a(Ansi.Attribute.ITALIC);
        this.buffer.a(value);
        this.buffer.a(Ansi.Attribute.ITALIC_OFF);
        this.buffer.reset();
        this.buffer.a("\"");
    }

    public static boolean isEmpty(String value) {
        return value == null || "".equals(value);
    }

    public void indent() {
        this.indent(1);
    }

    public void indent(int level) {
        for (int i = 0; i < level; ++i) {
            this.buffer.a(this.indenter);
        }
    }

    public void eol() {
        this.eol(1);
    }

    public void eol(int level) {
        for (int i = 0; i < level; ++i) {
            this.buffer.a('\n');
        }
    }

    public void red(String message) {
        this.color(message, Ansi.Color.RED);
    }

    public void green(String message) {
        this.color(message, Ansi.Color.GREEN);
    }

    public void blue(String message) {
        this.color(message, Ansi.Color.BLUE);
    }

    public void white(String message) {
        this.color(message, Ansi.Color.WHITE);
    }

    public void black(String message) {
        this.color(message, Ansi.Color.BLACK);
    }

    public void cyan(String message) {
        this.color(message, Ansi.Color.CYAN);
    }

    public void yellow(String message) {
        this.color(message, Ansi.Color.YELLOW);
    }

    public void magenta(String message) {
        this.color(message, Ansi.Color.MAGENTA);
    }

    public void color(String message, Ansi.Color color) {
        this.buffer.fg(color);
        this.buffer.a(message);
        this.buffer.reset();
    }

    public void italic(String message) {
        this.buffer.a(Ansi.Attribute.ITALIC);
        this.buffer.a(message);
        this.buffer.a(Ansi.Attribute.ITALIC_OFF);
    }

    public void bold(String message) {
        this.buffer.a(Ansi.Attribute.INTENSITY_BOLD);
        this.buffer.a(message);
        this.buffer.a(Ansi.Attribute.INTENSITY_BOLD_OFF);
    }

    public void underline(String message) {
        this.buffer.a(Ansi.Attribute.UNDERLINE);
        this.buffer.a(message);
        this.buffer.a(Ansi.Attribute.UNDERLINE_OFF);
    }

    public void print(String message) {
        this.buffer.a(message);
    }
}

