/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.services;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.ow2.chameleon.core.services.AbstractDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryBasedDeployer
extends AbstractDeployer {
    private final File directory;
    protected Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());

    public DirectoryBasedDeployer(File directory) {
        this.directory = directory;
    }

    @Override
    public boolean accept(File file) {
        if (this.directory == null) {
            throw new IllegalArgumentException("Directory must not be null");
        }
        if (!this.directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + this.directory);
        }
        if (file == null || !this.directory.exists()) {
            return false;
        }
        try {
            String canonicalParent = this.directory.getCanonicalPath();
            String canonicalChild = file.getCanonicalPath();
            return FilenameUtils.directoryContains((String)canonicalParent, (String)canonicalChild);
        }
        catch (IOException e) {
            this.logger.debug("Cannot check if {} is contained in {}", new Object[]{file.getAbsolutePath(), this.directory.getAbsolutePath(), e});
            return false;
        }
    }
}

