/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.processor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.ipojo.extender.internal.BundleProcessor;
import org.apache.felix.ipojo.extender.internal.declaration.DefaultInstanceDeclaration;
import org.apache.felix.ipojo.extender.internal.declaration.DefaultTypeDeclaration;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.ManifestMetadataParser;
import org.apache.felix.ipojo.parser.ParseException;
import org.apache.felix.ipojo.util.Log;
import org.osgi.framework.Bundle;

public class ComponentsBundleProcessor
implements BundleProcessor {
    public static final String IPOJO_HEADER = "iPOJO-Components";
    public static final String IPOJO_HEADER_ALT = "IPOJO-Components";
    public static final String COMPONENT_INSTANCE_ATTRIBUTE = "component";
    private final Log m_logger;
    private final Map<Bundle, ComponentsAndInstances> m_registry = new HashMap<Bundle, ComponentsAndInstances>();

    public ComponentsBundleProcessor(Log logger) {
        this.m_logger = logger;
    }

    public void activate(Bundle bundle) {
        Dictionary dict = bundle.getHeaders();
        String header = (String)dict.get(IPOJO_HEADER);
        if (header == null) {
            header = (String)dict.get(IPOJO_HEADER_ALT);
        }
        if (header != null) {
            try {
                this.parse(bundle, header);
            }
            catch (IOException e) {
                this.m_logger.log(1, "An exception occurs during the parsing of the bundle " + bundle.getBundleId(), e);
            }
            catch (ParseException e) {
                this.m_logger.log(1, "A parse exception occurs during the parsing of the bundle " + bundle.getBundleId(), e);
            }
        }
    }

    public void deactivate(Bundle bundle) {
        ComponentsAndInstances cai = this.m_registry.remove(bundle);
        if (cai != null) {
            cai.stop();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    private void parse(Bundle bundle, String components) throws IOException, ParseException {
        ManifestMetadataParser parser = new ManifestMetadataParser();
        parser.parseHeader(components);
        Element[] metadata = parser.getComponentsMetadata();
        for (int i = 0; i < metadata.length; ++i) {
            this.handleTypeDeclaration(bundle, metadata[i]);
        }
        Dictionary[] instances = parser.getInstances();
        for (int i = 0; instances != null && i < instances.length; ++i) {
            this.handleInstanceDeclaration(bundle, instances[i]);
        }
    }

    private void handleInstanceDeclaration(Bundle bundle, Dictionary instance) {
        String component = (String)instance.get(COMPONENT_INSTANCE_ATTRIBUTE);
        DefaultInstanceDeclaration declaration = new DefaultInstanceDeclaration(bundle.getBundleContext(), component, instance);
        declaration.start();
        this.getComponentsAndInstances((Bundle)bundle).m_instances.add(declaration);
    }

    private void handleTypeDeclaration(Bundle bundle, Element metadata) {
        DefaultTypeDeclaration declaration = new DefaultTypeDeclaration(bundle.getBundleContext(), metadata);
        declaration.start();
        this.getComponentsAndInstances((Bundle)bundle).m_types.add(declaration);
    }

    private ComponentsAndInstances getComponentsAndInstances(Bundle bundle) {
        ComponentsAndInstances cai = this.m_registry.get(bundle);
        if (cai == null) {
            cai = new ComponentsAndInstances();
            this.m_registry.put(bundle, cai);
        }
        return cai;
    }

    private static class ComponentsAndInstances {
        List<DefaultTypeDeclaration> m_types = new ArrayList<DefaultTypeDeclaration>();
        List<DefaultInstanceDeclaration> m_instances = new ArrayList<DefaultInstanceDeclaration>();

        private ComponentsAndInstances() {
        }

        void stop() {
            for (DefaultInstanceDeclaration instance : this.m_instances) {
                instance.stop();
            }
            for (DefaultTypeDeclaration declaration : this.m_types) {
                declaration.stop();
            }
            this.m_instances.clear();
            this.m_types.clear();
        }
    }
}

