/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ipojo.internal;

import java.util.List;
import java.util.Set;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.HandlerFactory;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.HandlerDeclaration;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.service.command.CommandSession;
import org.fusesource.jansi.Ansi;

@Command(name="handlers", scope="ipojo", description="List the handlers factories")
@Component
@HandlerDeclaration(value="<sh:command xmlns:sh='org.ow2.shelbie'/>")
public class HandlersAction
implements Action,
Pojo {
    private InstanceManager __IM;
    private boolean __Fhandlers;
    @Requires(optional=true)
    private HandlerFactory[] handlers;
    private boolean __Fverbose;
    @Option(name="-v", aliases={"--verbose"}, description="When activated, display additional HandlerFactory information.", required=false)
    private boolean verbose;
    private boolean __Mexecute$org_apache_felix_service_command_CommandSession;
    private boolean __MprintHandlerFactory$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_HandlerFactory;

    HandlerFactory[] __gethandlers() {
        if (!this.__Fhandlers) {
            return this.handlers;
        }
        return (HandlerFactory[])this.__IM.onGet((Object)this, "handlers");
    }

    void __sethandlers(HandlerFactory[] handlerFactoryArray) {
        if (!this.__Fhandlers) {
            this.handlers = handlerFactoryArray;
            return;
        }
        this.__IM.onSet((Object)this, "handlers", (Object)handlerFactoryArray);
    }

    boolean __getverbose() {
        if (!this.__Fverbose) {
            return this.verbose;
        }
        Object object = this.__IM.onGet((Object)this, "verbose");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setverbose(boolean bl) {
        if (!this.__Fverbose) {
            this.verbose = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "verbose", (Object)bl2);
    }

    public HandlersAction() {
        this(null);
    }

    private HandlersAction(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setverbose(false);
    }

    public Object execute(CommandSession commandSession) throws Exception {
        Object object;
        if (!this.__Mexecute$org_apache_felix_service_command_CommandSession) {
            return this.__M_execute(commandSession);
        }
        try {
            this.__IM.onEntry((Object)this, "execute$org_apache_felix_service_command_CommandSession", new Object[]{commandSession});
            object = this.__M_execute(commandSession);
            this.__IM.onExit((Object)this, "execute$org_apache_felix_service_command_CommandSession", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "execute$org_apache_felix_service_command_CommandSession", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_execute(CommandSession session) throws Exception {
        Ansi buffer = Ansi.ansi();
        for (HandlerFactory factory : this.__gethandlers()) {
            this.printHandlerFactory(buffer, factory);
        }
        System.out.println(buffer.toString());
        return null;
    }

    private void printHandlerFactory(Ansi ansi, HandlerFactory handlerFactory) {
        if (!this.__MprintHandlerFactory$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_HandlerFactory) {
            this.__M_printHandlerFactory(ansi, handlerFactory);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "printHandlerFactory$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_HandlerFactory", new Object[]{ansi, handlerFactory});
            this.__M_printHandlerFactory(ansi, handlerFactory);
            this.__IM.onExit((Object)this, "printHandlerFactory$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_HandlerFactory", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "printHandlerFactory$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_HandlerFactory", throwable);
            throw throwable;
        }
    }

    private void __M_printHandlerFactory(Ansi buffer, HandlerFactory factory) {
        String status = "INVALID";
        Ansi.Color color = Ansi.Color.RED;
        if (factory.getState() == 1) {
            status = "  VALID";
            color = Ansi.Color.GREEN;
        }
        buffer.a("[");
        buffer.fg(color);
        buffer.a(status);
        buffer.reset();
        buffer.a("] ");
        buffer.a(factory.getHandlerName());
        if (!"primitive".equals(factory.getType())) {
            buffer.a(" [" + factory.getType() + "]");
        }
        if (this.__getverbose() && factory.getVersion() != null) {
            buffer.a(" (v:" + factory.getVersion() + ")");
        }
        buffer.a('\n');
        if (this.__getverbose() && factory.getState() == 0) {
            List handlers = factory.getMissingHandlers();
            buffer.a("  [ ");
            for (String handler : handlers) {
                buffer.fg(Ansi.Color.RED);
                buffer.a(handler);
                buffer.reset();
                buffer.a(" ");
            }
            buffer.a("]\n");
        }
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("handlers")) {
                this.__Fhandlers = true;
            }
            if (set.contains("verbose")) {
                this.__Fverbose = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("execute$org_apache_felix_service_command_CommandSession")) {
                this.__Mexecute$org_apache_felix_service_command_CommandSession = true;
            }
            if (set.contains("printHandlerFactory$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_HandlerFactory")) {
                this.__MprintHandlerFactory$org_fusesource_jansi_Ansi$org_apache_felix_ipojo_HandlerFactory = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

