/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.ow2.chameleon.core.activators.UnmanagedConfiguration;
import org.ow2.chameleon.core.services.Deployer;
import org.ow2.chameleon.core.services.ExtensionBasedDeployer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigDeployer
extends ExtensionBasedDeployer
implements BundleActivator,
ServiceListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigDeployer.class);
    Map<File, Configuration> configurations = new HashMap<File, Configuration>();
    private BundleContext context;

    public ConfigDeployer() {
        super("cfg");
    }

    @Override
    public void start(BundleContext context) throws Exception {
        this.context = context;
        context.registerService(Deployer.class, this, null);
        context.addServiceListener(this, "(objectClass=" + ConfigurationAdmin.class.getName() + ")");
    }

    @Override
    public void stop(BundleContext context) throws Exception {
        this.removeAllConfigurations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties read(File file) throws IOException {
        Properties properties;
        FileInputStream in = null;
        try {
            Properties p = new Properties();
            in = new FileInputStream(file);
            p.load(in);
            properties = p;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }

    String[] parsePid(String path) {
        String pid = path.substring(0, path.length() - ".cfg".length());
        int n = pid.indexOf(45);
        if (n > 0) {
            String factoryPid = pid.substring(n + 1);
            pid = pid.substring(0, n);
            return new String[]{pid, factoryPid};
        }
        return new String[]{pid, null};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAndApplyConfiguration(File file, ConfigurationAdmin admin) throws Exception {
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            if (admin == null) {
                LOGGER.warn("Cannot apply configuration " + file.getName() + " - no configuration admin");
                this.configurations.put(file, UnmanagedConfiguration.INSTANCE);
            } else {
                Properties properties = this.read(file);
                String[] pid = this.parsePid(file.getName());
                Properties ht = new Properties();
                for (String k : properties.stringPropertyNames()) {
                    ((Dictionary)ht).put(k, properties.getProperty(k));
                }
                Configuration config = this.configurations.get(file);
                if ((config == null || config == UnmanagedConfiguration.INSTANCE) && (config = this.getConfiguration(pid[0], pid[1], admin)).getBundleLocation() != null) {
                    config.setBundleLocation(null);
                }
                LOGGER.info("Updating configuration {} in the configuration admin, configuration: {}", (Object)config.getPid(), this.configurations);
                config.update((Dictionary)ht);
                this.configurations.put(file, config);
            }
        }
    }

    private ConfigurationAdmin getConfigurationAdmin() {
        ServiceReference<ConfigurationAdmin> ref = this.context.getServiceReference(ConfigurationAdmin.class);
        if (ref == null) {
            return null;
        }
        return this.context.getService(ref);
    }

    Configuration getConfiguration(String pid, String factoryPid, ConfigurationAdmin cm) throws IOException {
        Configuration newConfiguration = factoryPid != null ? cm.createFactoryConfiguration(pid, "?") : cm.getConfiguration(pid, "?");
        return newConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileCreate(File file) {
        LOGGER.info("File creation event received for {}", (Object)file.getAbsoluteFile());
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            try {
                ConfigurationAdmin admin = this.getConfigurationAdmin();
                this.readAndApplyConfiguration(file, admin);
            }
            catch (Exception e) {
                LOGGER.error("Cannot find the configuration admin service", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileDelete(File file) {
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            Configuration configuration = this.configurations.remove(file);
            if (!configuration.equals((Object)UnmanagedConfiguration.INSTANCE)) {
                try {
                    LOGGER.info("Deleting configuration {}", (Object)configuration.getPid());
                    configuration.delete();
                }
                catch (Exception e) {
                    LOGGER.error("Cannot delete configuration from {}", (Object)configuration.getPid(), (Object)e);
                }
            }
        }
    }

    @Override
    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            ConfigurationAdmin admin = (ConfigurationAdmin)this.context.getService(event.getServiceReference());
            this.processAllConfigurations(admin);
        } else if (event.getType() == 4) {
            this.removeAllConfigurations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllConfigurations() {
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            for (Map.Entry<File, Configuration> entry : this.configurations.entrySet()) {
                if (!entry.getValue().equals((Object)UnmanagedConfiguration.INSTANCE)) continue;
                try {
                    LOGGER.info("Deleting configuration {}", (Object)entry.getValue().getPid());
                    entry.getValue().delete();
                    entry.setValue(UnmanagedConfiguration.INSTANCE);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot delete configuration from {}", (Object)entry.getKey().getAbsoluteFile(), (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAllConfigurations(ConfigurationAdmin admin) {
        ConfigDeployer configDeployer = this;
        synchronized (configDeployer) {
            for (Map.Entry<File, Configuration> entry : this.configurations.entrySet()) {
                if (!entry.getValue().equals((Object)UnmanagedConfiguration.INSTANCE)) continue;
                try {
                    this.readAndApplyConfiguration(entry.getKey(), admin);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot apply configuration from {}", (Object)entry.getKey().getAbsoluteFile(), (Object)e);
                }
            }
        }
    }
}

