/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.launch.Framework;
import org.ow2.chameleon.core.Chameleon;
import org.ow2.chameleon.core.ChameleonConfiguration;
import org.ow2.chameleon.core.utils.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkManager {
    private final Framework framework;
    private final List<BundleActivator> activators = new ArrayList<BundleActivator>();
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameworkManager.class);
    private final ChameleonConfiguration configuration;
    private final Chameleon chameleon;

    public FrameworkManager(Chameleon chameleon, ChameleonConfiguration configuration) throws IOException {
        this.configuration = configuration;
        this.chameleon = chameleon;
        this.framework = FrameworkUtil.create(configuration);
    }

    public Framework get() {
        return this.framework;
    }

    public Framework start() throws BundleException {
        this.framework.init();
        if (this.configuration.isInteractiveModeEnabled()) {
            try {
                this.framework.getBundleContext().addServiceListener(new ServiceListener(){

                    @Override
                    public void serviceChanged(ServiceEvent event) {
                        if (event.getType() == 4) {
                            LOGGER.warn("Shelbie system Service leaving - shutting down sequence detected");
                            try {
                                FrameworkManager.this.chameleon.stop();
                            }
                            catch (Exception e) {
                                LOGGER.error("Error during the framework stopping process", (Throwable)e);
                            }
                        }
                    }
                }, "(objectClass=org.ow2.shelbie.core.system.SystemService)");
            }
            catch (InvalidSyntaxException e) {
                LOGGER.error("LDAP Syntax error", (Throwable)e);
            }
        }
        this.framework.start();
        for (BundleActivator activator : this.activators) {
            try {
                activator.start(this.framework.getBundleContext());
            }
            catch (Exception e) {
                LOGGER.error("Cannot start internal activator : {}", (Object)activator, (Object)e);
                throw new BundleException("Cannot start internal activator : " + activator + " : " + e.getMessage(), e);
            }
        }
        return this.framework;
    }

    public void stop() throws BundleException, InterruptedException {
        for (BundleActivator activator : this.activators) {
            try {
                activator.stop(this.framework.getBundleContext());
            }
            catch (Exception e) {
                LOGGER.error("Error during the stopping of {}", (Object)activator, (Object)e);
            }
        }
        this.framework.stop();
        this.framework.waitForStop(1000L);
    }

    public void addActivators(List<BundleActivator> activators) {
        this.activators.addAll(activators);
    }
}

