/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.converter.manager;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.felix.gogo.commands.converter.GenericType;
import org.apache.felix.gogo.commands.converter.ReifiedType;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.whiteboard.Wbp;
import org.apache.felix.service.command.Converter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.shelbie.core.IConverterManager;
import org.ow2.shelbie.core.TypeBasedConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
@Wbp(filter="(objectClass=org.apache.felix.service.command.Converter)", onArrival="addConverter", onDeparture="removeConverter", onModification="updateConverter")
public class ConverterManagerImpl
implements IConverterManager,
Pojo {
    private InstanceManager __IM;
    private boolean __FsupportedClassesByConverter;
    private final Map<Converter, Set<Class<?>>> supportedClassesByConverter;
    private boolean __FconverterByRef;
    private final TreeMap<ServiceReference, Converter> converterByRef;
    private boolean __FbundleContext;
    private final BundleContext bundleContext;
    private boolean __MaddConverter$org_osgi_framework_ServiceReference;
    private boolean __MremoveConverter$org_osgi_framework_ServiceReference;
    private boolean __MupdateConverter$org_osgi_framework_ServiceReference;
    private boolean __MfindSupportedClasses$org_osgi_framework_ServiceReference;
    private boolean __Mconvert$org_apache_felix_gogo_commands_converter_ReifiedType$java_lang_Object;
    private boolean __Mconvert$java_lang_reflect_Type$java_lang_Object;
    private boolean __MisSupportedClass$java_lang_Class$java_util_Set;

    Map __getsupportedClassesByConverter() {
        if (!this.__FsupportedClassesByConverter) {
            return this.supportedClassesByConverter;
        }
        return (Map)this.__IM.onGet((Object)this, "supportedClassesByConverter");
    }

    void __setsupportedClassesByConverter(Map map) {
        if (!this.__FsupportedClassesByConverter) {
            this.supportedClassesByConverter = map;
            return;
        }
        this.__IM.onSet((Object)this, "supportedClassesByConverter", (Object)map);
    }

    TreeMap __getconverterByRef() {
        if (!this.__FconverterByRef) {
            return this.converterByRef;
        }
        return (TreeMap)this.__IM.onGet((Object)this, "converterByRef");
    }

    void __setconverterByRef(TreeMap treeMap) {
        if (!this.__FconverterByRef) {
            this.converterByRef = treeMap;
            return;
        }
        this.__IM.onSet((Object)this, "converterByRef", (Object)treeMap);
    }

    BundleContext __getbundleContext() {
        if (!this.__FbundleContext) {
            return this.bundleContext;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "bundleContext");
    }

    void __setbundleContext(BundleContext bundleContext) {
        if (!this.__FbundleContext) {
            this.bundleContext = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "bundleContext", (Object)bundleContext);
    }

    public ConverterManagerImpl(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private ConverterManagerImpl(InstanceManager _manager, BundleContext bundleContext) {
        this._setInstanceManager(_manager);
        this.__setsupportedClassesByConverter(new IdentityHashMap());
        this.__setconverterByRef(new TreeMap(Collections.reverseOrder()));
        this.__setbundleContext(bundleContext);
    }

    public void addConverter(ServiceReference ref) {
        if (!this.__MaddConverter$org_osgi_framework_ServiceReference) {
            this.__M_addConverter(ref);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addConverter$org_osgi_framework_ServiceReference", new Object[]{ref});
            this.__M_addConverter(ref);
            this.__IM.onExit((Object)this, "addConverter$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addConverter$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __M_addConverter(ServiceReference ref) {
        Converter converter = (Converter)this.__getbundleContext().getService(ref);
        this.__getsupportedClassesByConverter().put(converter, this.findSupportedClasses(ref));
        this.__getconverterByRef().put(ref, converter);
    }

    public void removeConverter(ServiceReference ref) {
        if (!this.__MremoveConverter$org_osgi_framework_ServiceReference) {
            this.__M_removeConverter(ref);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeConverter$org_osgi_framework_ServiceReference", new Object[]{ref});
            this.__M_removeConverter(ref);
            this.__IM.onExit((Object)this, "removeConverter$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeConverter$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __M_removeConverter(ServiceReference ref) {
        Converter converter = (Converter)this.__getconverterByRef().remove(ref);
        if (converter != null) {
            this.__getsupportedClassesByConverter().remove(converter);
            this.__getbundleContext().ungetService(ref);
        }
    }

    public void updateConverter(ServiceReference ref) {
        if (!this.__MupdateConverter$org_osgi_framework_ServiceReference) {
            this.__M_updateConverter(ref);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "updateConverter$org_osgi_framework_ServiceReference", new Object[]{ref});
            this.__M_updateConverter(ref);
            this.__IM.onExit((Object)this, "updateConverter$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "updateConverter$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __M_updateConverter(ServiceReference ref) {
        this.__getsupportedClassesByConverter().put(this.__getconverterByRef().get(ref), this.findSupportedClasses(ref));
    }

    private Set<Class<?>> findSupportedClasses(ServiceReference ref) {
        Set<Class<?>> set;
        if (!this.__MfindSupportedClasses$org_osgi_framework_ServiceReference) {
            return this.__M_findSupportedClasses(ref);
        }
        try {
            this.__IM.onEntry((Object)this, "findSupportedClasses$org_osgi_framework_ServiceReference", new Object[]{ref});
            set = this.__M_findSupportedClasses(ref);
            this.__IM.onExit((Object)this, "findSupportedClasses$org_osgi_framework_ServiceReference", set);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "findSupportedClasses$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
        return set;
    }

    private Set<Class<?>> __M_findSupportedClasses(ServiceReference ref) {
        Object classes = ref.getProperty("osgi.converter.classes");
        HashSet<Class<Object>> supportedClasses = null;
        if (classes instanceof String) {
            supportedClasses = new HashSet();
            try {
                supportedClasses.add(ref.getBundle().loadClass((String)classes));
            }
            catch (ClassNotFoundException e) {}
        } else if (classes instanceof String[]) {
            supportedClasses = new HashSet();
            for (String c : (String[])classes) {
                try {
                    supportedClasses.add(ref.getBundle().loadClass(c));
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        return supportedClasses;
    }

    @Override
    public Object convert(ReifiedType desiredType, Object in) throws Exception {
        Object object;
        if (!this.__Mconvert$org_apache_felix_gogo_commands_converter_ReifiedType$java_lang_Object) {
            return this.__M_convert(desiredType, in);
        }
        try {
            this.__IM.onEntry((Object)this, "convert$org_apache_felix_gogo_commands_converter_ReifiedType$java_lang_Object", new Object[]{desiredType, in});
            object = this.__M_convert(desiredType, in);
            this.__IM.onExit((Object)this, "convert$org_apache_felix_gogo_commands_converter_ReifiedType$java_lang_Object", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convert$org_apache_felix_gogo_commands_converter_ReifiedType$java_lang_Object", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_convert(ReifiedType desiredType, Object in) throws Exception {
        if (desiredType.size() == 0 && desiredType.getRawClass().isAssignableFrom(in.getClass())) {
            return in;
        }
        for (Converter converter : this.__getconverterByRef().values()) {
            Object result;
            Set supportedClasses = (Set)this.__getsupportedClassesByConverter().get(converter);
            if (supportedClasses != null && !this.isSupportedClass(desiredType.getRawClass(), supportedClasses) || (result = converter instanceof TypeBasedConverter ? ((TypeBasedConverter)converter).convert(desiredType, in) : converter.convert(desiredType.getRawClass(), in)) == null) continue;
            return result;
        }
        if (desiredType.getRawClass().equals(String.class)) {
            return in.toString();
        }
        return null;
    }

    @Override
    public Object convert(Type desiredType, Object in) throws Exception {
        Object object;
        if (!this.__Mconvert$java_lang_reflect_Type$java_lang_Object) {
            return this.__M_convert(desiredType, in);
        }
        try {
            this.__IM.onEntry((Object)this, "convert$java_lang_reflect_Type$java_lang_Object", new Object[]{desiredType, in});
            object = this.__M_convert(desiredType, in);
            this.__IM.onExit((Object)this, "convert$java_lang_reflect_Type$java_lang_Object", object);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "convert$java_lang_reflect_Type$java_lang_Object", throwable);
            throw throwable;
        }
        return object;
    }

    private Object __M_convert(Type desiredType, Object in) throws Exception {
        GenericType genericType = new GenericType(desiredType);
        return this.convert(genericType, in);
    }

    private boolean isSupportedClass(Class<?> clazz, Set<Class<?>> supportedClasses) {
        boolean bl;
        if (!this.__MisSupportedClass$java_lang_Class$java_util_Set) {
            return this.__M_isSupportedClass(clazz, supportedClasses);
        }
        try {
            this.__IM.onEntry((Object)this, "isSupportedClass$java_lang_Class$java_util_Set", new Object[]{clazz, supportedClasses});
            bl = this.__M_isSupportedClass(clazz, supportedClasses);
            this.__IM.onExit((Object)this, "isSupportedClass$java_lang_Class$java_util_Set", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isSupportedClass$java_lang_Class$java_util_Set", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isSupportedClass(Class<?> clazz, Set<Class<?>> supportedClasses) {
        for (Class<?> c : supportedClasses) {
            if (!c.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("bundleContext")) {
                this.__FbundleContext = true;
            }
            if (set.contains("converterByRef")) {
                this.__FconverterByRef = true;
            }
            if (set.contains("supportedClassesByConverter")) {
                this.__FsupportedClassesByConverter = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("addConverter$org_osgi_framework_ServiceReference")) {
                this.__MaddConverter$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("removeConverter$org_osgi_framework_ServiceReference")) {
                this.__MremoveConverter$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("updateConverter$org_osgi_framework_ServiceReference")) {
                this.__MupdateConverter$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("findSupportedClasses$org_osgi_framework_ServiceReference")) {
                this.__MfindSupportedClasses$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("convert$org_apache_felix_gogo_commands_converter_ReifiedType$java_lang_Object")) {
                this.__Mconvert$org_apache_felix_gogo_commands_converter_ReifiedType$java_lang_Object = true;
            }
            if (set.contains("convert$java_lang_reflect_Type$java_lang_Object")) {
                this.__Mconvert$java_lang_reflect_Type$java_lang_Object = true;
            }
            if (set.contains("isSupportedClass$java_lang_Class$java_util_Set")) {
                this.__MisSupportedClass$java_lang_Class$java_util_Set = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

