/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.felix.gogo.api.CommandSessionListener;
import org.apache.felix.gogo.runtime.CommandProxy;
import org.apache.felix.gogo.runtime.CommandSessionImpl;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandProcessorImpl
implements CommandProcessor {
    protected final Set<Converter> converters = new CopyOnWriteArraySet<Converter>();
    protected final Set<CommandSessionListener> listeners = new CopyOnWriteArraySet<CommandSessionListener>();
    protected final Map<String, Object> commands = new LinkedHashMap<String, Object>();
    protected final Map<String, Object> constants = new HashMap<String, Object>();
    protected final ThreadIO threadIO;
    protected final WeakHashMap<CommandSession, Object> sessions = new WeakHashMap();

    public CommandProcessorImpl(ThreadIO tio) {
        this.threadIO = tio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandSession createSession(InputStream in, PrintStream out, PrintStream err) {
        WeakHashMap<CommandSession, Object> weakHashMap = this.sessions;
        synchronized (weakHashMap) {
            CommandSessionImpl session = new CommandSessionImpl(this, in, out, err);
            this.sessions.put(session, null);
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        WeakHashMap<CommandSession, Object> weakHashMap = this.sessions;
        synchronized (weakHashMap) {
            for (CommandSession session : this.sessions.keySet()) {
                session.close();
            }
        }
    }

    public void addConverter(Converter c) {
        this.converters.add(c);
    }

    public void removeConverter(Converter c) {
        this.converters.remove(c);
    }

    public void addListener(CommandSessionListener l) {
        this.listeners.add(l);
    }

    public void removeListener(CommandSessionListener l) {
        this.listeners.remove(l);
    }

    public Set<String> getCommands() {
        return Collections.unmodifiableSet(this.commands.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Function getCommand(String name, Object path) {
        int colon = name.indexOf(58);
        if (colon < 0) {
            return null;
        }
        name = name.toLowerCase();
        String cfunction = name.substring(colon);
        boolean anyScope = colon == 1 && name.charAt(0) == '*';
        Object cmd = this.commands.get(name);
        if (null == cmd && anyScope) {
            String scopePath = null == path ? "*" : path.toString();
            for (String scope : scopePath.split(":")) {
                if (scope.equals("*")) {
                    Map<String, Object> map = this.commands;
                    synchronized (map) {
                        for (Map.Entry<String, Object> entry : this.commands.entrySet()) {
                            if (!entry.getKey().endsWith(cfunction)) continue;
                            cmd = entry.getValue();
                            break;
                        }
                    }
                } else {
                    cmd = this.commands.get(scope + cfunction);
                }
                if (cmd != null) break;
            }
        }
        if (null == cmd || cmd instanceof Function) {
            return (Function)cmd;
        }
        return new CommandProxy(cmd, cfunction.substring(1));
    }

    public void addCommand(String scope, Object target) {
        Class<?> tc = target instanceof Class ? (Class<?>)target : target.getClass();
        this.addCommand(scope, target, tc);
    }

    public void addCommand(String scope, Object target, Class<?> functions) {
        String[] names;
        if (target == null) {
            return;
        }
        for (String function : names = this.getFunctions(functions)) {
            this.addCommand(scope, target, function);
        }
    }

    public Object addConstant(String name, Object target) {
        return this.constants.put(name, target);
    }

    public Object removeConstant(String name) {
        return this.constants.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(String scope, Object target, String function) {
        Map<String, Object> map = this.commands;
        synchronized (map) {
            this.commands.put((scope + ":" + function).toLowerCase(), target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(String scope, String function) {
        String func = (scope + ":" + function).toLowerCase();
        Map<String, Object> map = this.commands;
        synchronized (map) {
            this.commands.remove(func);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(Object target) {
        Map<String, Object> map = this.commands;
        synchronized (map) {
            Iterator<Object> i = this.commands.values().iterator();
            while (i.hasNext()) {
                if (i.next() != target) continue;
                i.remove();
            }
        }
    }

    private String[] getFunctions(Class<?> target) {
        Method[] methods;
        TreeSet<String> list = new TreeSet<String>();
        for (Method m : methods = target.getMethods()) {
            String s;
            if (m.getDeclaringClass().equals(Object.class)) continue;
            list.add(m.getName());
            if (!m.getName().startsWith("get") || (s = m.getName().substring(3)).length() <= 0) continue;
            list.add(s.substring(0, 1).toLowerCase() + s.substring(1));
        }
        String[] functions = list.toArray(new String[list.size()]);
        return functions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(String name, Object target) {
        Map<String, Object> map = this.commands;
        synchronized (map) {
            this.commands.put(name, target);
        }
    }

    public Object convert(Class<?> desiredType, Object in) {
        for (Converter c : this.converters) {
            try {
                Object converted = c.convert(desiredType, in);
                if (converted == null) continue;
                return converted;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Object eval(CommandSession session, Object[] argv) throws Exception {
        StringBuilder buf = new StringBuilder();
        for (Object arg : argv) {
            if (buf.length() > 0) {
                buf.append(' ');
            }
            buf.append(arg);
        }
        return session.execute(buf);
    }

    void beforeExecute(CommandSession session, CharSequence commandline) {
        for (CommandSessionListener l : this.listeners) {
            try {
                l.beforeExecute(session, commandline);
            }
            catch (Throwable t) {}
        }
    }

    void afterExecute(CommandSession session, CharSequence commandline, Exception exception) {
        for (CommandSessionListener l : this.listeners) {
            try {
                l.afterExecute(session, commandline, exception);
            }
            catch (Throwable t) {}
        }
    }

    void afterExecute(CommandSession session, CharSequence commandline, Object result) {
        for (CommandSessionListener l : this.listeners) {
            try {
                l.afterExecute(session, commandline, result);
            }
            catch (Throwable t) {}
        }
    }
}

