/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.utils;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import org.ow2.chameleon.core.ChameleonConfiguration;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogbackUtil {
    private LogbackUtil() {
    }

    public static Logger configure(ChameleonConfiguration configuration) {
        ILoggerFactory obj = LoggerFactory.getILoggerFactory();
        if (!(obj instanceof LoggerContext)) {
            return LoggerFactory.getLogger((String)"org.ow2.chameleon");
        }
        LoggerContext context = (LoggerContext)obj;
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            configurator.doConfigure(configuration.getRelativeFile("conf/logger.xml"));
            ch.qos.logback.classic.Logger logger = context.getLogger("org.ow2.chameleon");
            if (configuration.isInteractiveModeEnabled()) {
                logger.setLevel(Level.DEBUG);
            }
            return logger;
        }
        catch (JoranException je) {
            Logger log = LoggerFactory.getLogger((String)"org.ow2.chameleon");
            log.error("Cannot configure the logging system from {}", (Object)"conf/logger.xml", (Object)je);
            return log;
        }
    }
}

