/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.services;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.ow2.chameleon.core.services.AbstractDeployer;

public class ExtensionBasedDeployer
extends AbstractDeployer {
    private final List<String> extensions;

    public ExtensionBasedDeployer(String[] extensions) {
        this(Arrays.asList(extensions));
    }

    public ExtensionBasedDeployer(String extension) {
        this(new String[]{extension});
    }

    public ExtensionBasedDeployer(List<String> extensions) {
        this.extensions = ImmutableList.copyOf(extensions);
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean accept(File file) {
        String extension = FilenameUtils.getExtension((String)file.getName());
        return this.extensions.contains(extension);
    }
}

