/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.core.internal.handler.completer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.NullCompleter;
import jline.console.completer.StringsCompleter;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.whiteboard.Wbp;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.shelbie.core.ICompletable;
import org.ow2.shelbie.core.internal.handler.completer.CharSequenceComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Provides
@Wbp(filter="(&(osgi.command.scope=*)(osgi.command.function=*))", onArrival="bindCommand", onDeparture="unbindCommand")
public class CommandsCompleter
implements Completer,
Pojo {
    private InstanceManager __IM;
    private boolean __Freferences;
    private List<ServiceReference> references;
    private boolean __Fcontext;
    private BundleContext context;
    private boolean __Ftype;
    @ServiceProperty(value="commands")
    private String type;
    private boolean __MbindCommand$org_osgi_framework_ServiceReference;
    private boolean __MunbindCommand$org_osgi_framework_ServiceReference;
    private boolean __MgetFunctionNames$org_osgi_framework_ServiceReference;
    private boolean __MaddFunction$java_util_List$java_lang_String$java_lang_String;
    private boolean __Mcomplete$java_lang_String$int$java_util_List;
    private boolean __MgetCompleters;

    List __getreferences() {
        if (!this.__Freferences) {
            return this.references;
        }
        return (List)this.__IM.onGet((Object)this, "references");
    }

    void __setreferences(List list) {
        if (!this.__Freferences) {
            this.references = list;
            return;
        }
        this.__IM.onSet((Object)this, "references", (Object)list);
    }

    BundleContext __getcontext() {
        if (!this.__Fcontext) {
            return this.context;
        }
        return (BundleContext)this.__IM.onGet((Object)this, "context");
    }

    void __setcontext(BundleContext bundleContext) {
        if (!this.__Fcontext) {
            this.context = bundleContext;
            return;
        }
        this.__IM.onSet((Object)this, "context", (Object)bundleContext);
    }

    String __gettype() {
        if (!this.__Ftype) {
            return this.type;
        }
        return (String)this.__IM.onGet((Object)this, "type");
    }

    void __settype(String string) {
        if (!this.__Ftype) {
            this.type = string;
            return;
        }
        this.__IM.onSet((Object)this, "type", (Object)string);
    }

    public CommandsCompleter(BundleContext bundleContext) {
        this(null, bundleContext);
    }

    private CommandsCompleter(InstanceManager _manager, BundleContext context) {
        this._setInstanceManager(_manager);
        this.__setreferences(new ArrayList());
        this.__setcontext(context);
    }

    public void bindCommand(ServiceReference reference) {
        if (!this.__MbindCommand$org_osgi_framework_ServiceReference) {
            this.__M_bindCommand(reference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "bindCommand$org_osgi_framework_ServiceReference", new Object[]{reference});
            this.__M_bindCommand(reference);
            this.__IM.onExit((Object)this, "bindCommand$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "bindCommand$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __M_bindCommand(ServiceReference reference) {
        this.__getreferences().add(reference);
    }

    public void unbindCommand(ServiceReference reference) {
        if (!this.__MunbindCommand$org_osgi_framework_ServiceReference) {
            this.__M_unbindCommand(reference);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindCommand$org_osgi_framework_ServiceReference", new Object[]{reference});
            this.__M_unbindCommand(reference);
            this.__IM.onExit((Object)this, "unbindCommand$org_osgi_framework_ServiceReference", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindCommand$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
    }

    private void __M_unbindCommand(ServiceReference reference) {
        this.__getreferences().remove(reference);
    }

    private String[] getFunctionNames(ServiceReference reference) {
        String[] stringArray;
        if (!this.__MgetFunctionNames$org_osgi_framework_ServiceReference) {
            return this.__M_getFunctionNames(reference);
        }
        try {
            this.__IM.onEntry((Object)this, "getFunctionNames$org_osgi_framework_ServiceReference", new Object[]{reference});
            stringArray = this.__M_getFunctionNames(reference);
            this.__IM.onExit((Object)this, "getFunctionNames$org_osgi_framework_ServiceReference", (Object)stringArray);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getFunctionNames$org_osgi_framework_ServiceReference", throwable);
            throw throwable;
        }
        return stringArray;
    }

    private String[] __M_getFunctionNames(ServiceReference reference) {
        ArrayList<String> names = new ArrayList<String>();
        Object functionValue = reference.getProperty("osgi.command.function");
        String scope = (String)reference.getProperty("osgi.command.scope");
        if (functionValue.getClass().isArray() && String.class.equals(functionValue.getClass().getComponentType())) {
            String[] values;
            for (String name : values = (String[])functionValue) {
                this.addFunction(names, scope, name);
            }
        } else {
            this.addFunction(names, scope, functionValue.toString());
        }
        return names.toArray(new String[names.size()]);
    }

    private void addFunction(List<String> names, String scope, String name) {
        if (!this.__MaddFunction$java_util_List$java_lang_String$java_lang_String) {
            this.__M_addFunction(names, scope, name);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addFunction$java_util_List$java_lang_String$java_lang_String", new Object[]{names, scope, name});
            this.__M_addFunction(names, scope, name);
            this.__IM.onExit((Object)this, "addFunction$java_util_List$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addFunction$java_util_List$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_addFunction(List<String> names, String scope, String name) {
        names.add(scope + ":" + name);
        names.add(name);
    }

    @Override
    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        int n;
        if (!this.__Mcomplete$java_lang_String$int$java_util_List) {
            return this.__M_complete(buffer, cursor, candidates);
        }
        try {
            this.__IM.onEntry((Object)this, "complete$java_lang_String$int$java_util_List", new Object[]{buffer, new Integer(cursor), candidates});
            n = this.__M_complete(buffer, cursor, candidates);
            this.__IM.onExit((Object)this, "complete$java_lang_String$int$java_util_List", (Object)new Integer(n));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "complete$java_lang_String$int$java_util_List", throwable);
            throw throwable;
        }
        return n;
    }

    private int __M_complete(String buffer, int cursor, List<CharSequence> candidates) {
        int res = new AggregateCompleter(this.getCompleters()).complete(buffer, cursor, candidates);
        Collections.sort(candidates, new CharSequenceComparator());
        return res;
    }

    private Collection<Completer> getCompleters() {
        Collection<Completer> collection;
        if (!this.__MgetCompleters) {
            return this.__M_getCompleters();
        }
        try {
            this.__IM.onEntry((Object)this, "getCompleters", new Object[0]);
            collection = this.__M_getCompleters();
            this.__IM.onExit((Object)this, "getCompleters", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCompleters", throwable);
            throw throwable;
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Completer> __M_getCompleters() {
        ArrayList<Completer> completers = new ArrayList<Completer>();
        for (ServiceReference reference : this.__getreferences()) {
            String[] functionNames = this.getFunctionNames(reference);
            ArrayList<Completer> cl = new ArrayList<Completer>();
            cl.add(new StringsCompleter(functionNames));
            try {
                Object service = this.__getcontext().getService(reference);
                if (service instanceof ICompletable) {
                    ICompletable completable = (ICompletable)service;
                    List<Completer> commandCompleters = completable.getCompleters();
                    if (commandCompleters != null) {
                        for (Completer completer : commandCompleters) {
                            if (completer == null) {
                                cl.add(new NullCompleter());
                                continue;
                            }
                            cl.add(completer);
                        }
                    }
                } else {
                    cl.add(new NullCompleter());
                }
                completers.add(new ArgumentCompleter(cl));
            }
            finally {
                this.__getcontext().ungetService(reference);
            }
        }
        return completers;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("context")) {
                this.__Fcontext = true;
            }
            if (set.contains("references")) {
                this.__Freferences = true;
            }
            if (set.contains("type")) {
                this.__Ftype = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("bindCommand$org_osgi_framework_ServiceReference")) {
                this.__MbindCommand$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("unbindCommand$org_osgi_framework_ServiceReference")) {
                this.__MunbindCommand$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("getFunctionNames$org_osgi_framework_ServiceReference")) {
                this.__MgetFunctionNames$org_osgi_framework_ServiceReference = true;
            }
            if (set.contains("addFunction$java_util_List$java_lang_String$java_lang_String")) {
                this.__MaddFunction$java_util_List$java_lang_String$java_lang_String = true;
            }
            if (set.contains("complete$java_lang_String$int$java_util_List")) {
                this.__Mcomplete$java_lang_String$int$java_util_List = true;
            }
            if (set.contains("getCompleters")) {
                this.__MgetCompleters = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

