/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.ow2.chameleon.core.services.Deployer;
import org.ow2.chameleon.core.services.Watcher;
import org.ow2.chameleon.core.utils.MonitorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryMonitor
implements BundleActivator,
Watcher,
ServiceTrackerCustomizer<Deployer, Deployer> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryMonitor.class);
    protected final List<Deployer> deployers = new ArrayList<Deployer>();
    private Map<File, FileAlterationMonitor> monitors = new LinkedHashMap<File, FileAlterationMonitor>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private ServiceTracker<Deployer, Deployer> tracker;
    private BundleContext context;
    private ServiceRegistration<Watcher> reg;

    public boolean acquireWriteLockIfNotHeld() {
        if (!this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().lock();
            return true;
        }
        return false;
    }

    public boolean releaseWriteLockIfHeld() {
        if (this.lock.isWriteLockedByCurrentThread()) {
            this.lock.writeLock().unlock();
        }
        return this.lock.getWriteHoldCount() == 0;
    }

    public boolean acquireReadLockIfNotHeld() {
        if (this.lock.getReadHoldCount() == 0) {
            this.lock.readLock().lock();
            return true;
        }
        return false;
    }

    public boolean releaseReadLockIfHeld() {
        if (this.lock.getReadHoldCount() != 0) {
            this.lock.readLock().unlock();
        }
        return this.lock.getReadHoldCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(BundleContext context) throws IOException {
        this.context = context;
        LOGGER.info("Starting watcher service configured for {}", this.monitors.keySet());
        this.tracker = new ServiceTracker<Deployer, Deployer>(context, Deployer.class.getName(), this);
        try {
            this.acquireWriteLockIfNotHeld();
            this.tracker.open();
            for (Map.Entry<File, FileAlterationMonitor> entry : this.monitors.entrySet()) {
                if (entry.getValue() != null) {
                    LOGGER.info("Starting file monitoring for {}", (Object)entry.getKey().getName());
                    try {
                        entry.getValue().start();
                        continue;
                    }
                    catch (Exception e) {
                        throw new IOException("Cannot start the monitoring of " + entry.getKey().getAbsolutePath(), e);
                    }
                }
                LOGGER.debug("No file monitoring for {}", (Object)entry.getKey().getName());
            }
            this.reg = context.registerService(Watcher.class, this, null);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    private List<File> getAcceptedFilesByTheDeployer(Collection<File> files, Deployer deployer) {
        ArrayList<File> accepted = new ArrayList<File>();
        for (File file : files) {
            if (!deployer.accept(file)) continue;
            accepted.add(file);
        }
        return accepted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(BundleContext context) {
        try {
            this.acquireWriteLockIfNotHeld();
            this.tracker.close();
            if (this.reg != null) {
                this.reg.unregister();
                this.reg = null;
            }
            for (Map.Entry<File, FileAlterationMonitor> entry : this.monitors.entrySet()) {
                if (entry.getValue() == null) continue;
                LOGGER.debug("Stopping file monitoring of {}", (Object)entry.getKey().getAbsolutePath());
                try {
                    entry.getValue().stop();
                    LOGGER.debug("File monitoring stopped");
                }
                catch (IllegalStateException e) {
                    LOGGER.warn("Stopping an already stopped file monitor on {}.", (Object)entry.getKey().getAbsolutePath());
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error("Something bad happened while trying to stop the file monitor", (Throwable)e);
                }
            }
            this.monitors.clear();
            this.context = null;
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
        for (Deployer deployer : this.deployers) {
            deployer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Deployer addingService(ServiceReference<Deployer> reference) {
        Deployer deployer = this.context.getService(reference);
        try {
            this.acquireWriteLockIfNotHeld();
            this.deployers.add(deployer);
            for (File directory : this.monitors.keySet()) {
                Collection files = FileUtils.listFiles((File)directory, null, (boolean)true);
                List<File> accepted = this.getAcceptedFilesByTheDeployer(files, deployer);
                LOGGER.info("Opening deployer {} for directory {}.", (Object)deployer, (Object)directory.getAbsolutePath());
                deployer.open(accepted);
            }
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
        return deployer;
    }

    @Override
    public void modifiedService(ServiceReference<Deployer> reference, Deployer o) {
    }

    @Override
    public void removedService(ServiceReference<Deployer> reference, Deployer deployer) {
        try {
            this.acquireWriteLockIfNotHeld();
            this.deployers.remove(deployer);
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Deployer> getDeployersAcceptingFile(File file) {
        ArrayList<Deployer> depl = new ArrayList<Deployer>();
        try {
            this.acquireReadLockIfNotHeld();
            for (Deployer deployer : this.deployers) {
                if (!deployer.accept(file)) continue;
                depl.add(deployer);
            }
        }
        finally {
            this.releaseReadLockIfHeld();
        }
        return depl;
    }

    @Override
    public boolean add(File directory, boolean watch) {
        if (watch) {
            return this.add(directory, 2000L);
        }
        return this.add(directory, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int isDirectoryAlreadyMonitored(File directory) {
        try {
            this.acquireWriteLockIfNotHeld();
            if (this.monitors.containsKey(directory)) {
                if (this.monitors.get(directory) != null) {
                    int n = 0;
                    return n;
                }
                int n = 2;
                return n;
            }
            for (Map.Entry<File, FileAlterationMonitor> entry : this.monitors.entrySet()) {
                File dir = entry.getKey();
                if (!FilenameUtils.directoryContains((String)dir.getCanonicalPath(), (String)directory.getCanonicalPath()) || entry.getValue() == null) continue;
                int n = 1;
                return n;
            }
            int n = 3;
            return n;
        }
        catch (IOException e) {
            LOGGER.error("Cannot determine whether the directory is already monitored or not", (Throwable)e);
            int n = 3;
            return n;
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(File directory, long polling) {
        try {
            this.acquireWriteLockIfNotHeld();
            int status = this.isDirectoryAlreadyMonitored(directory);
            if (status <= 1) {
                if (status == 1) {
                    LOGGER.warn("Cannot add {} to the Directory Monitor, a parent directory is already monitored.", (Object)directory);
                } else {
                    LOGGER.warn("Cannot add {} to the Directory Monitor,the directory is already monitored.", (Object)directory);
                }
                boolean bl = false;
                return bl;
            }
            if (polling == -1L && status == 2) {
                LOGGER.warn("Cannot add {} to the Directory Monitor, the directory is already there as not monitor (as requested).", (Object)directory);
                boolean bl = false;
                return bl;
            }
            if (polling == -1L) {
                this.monitors.put(directory, null);
                if (this.context != null) {
                    this.openDeployers(directory);
                }
                boolean bl = true;
                return bl;
            }
            if (!directory.isDirectory()) {
                LOGGER.info("Monitored directory {} not existing - creating directory", (Object)directory.getAbsolutePath());
                boolean created = directory.mkdirs();
                LOGGER.debug("Monitored direction {} creation ? {}", (Object)directory.getAbsolutePath(), (Object)created);
            }
            FileAlterationMonitor monitor = this.createFileAlterationMonitor(directory, polling);
            if (this.context != null) {
                monitor.start();
                this.openDeployers(directory);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("Cannot start the file monitoring on {}", (Object)directory, (Object)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    private FileAlterationMonitor createFileAlterationMonitor(File directory, long polling) {
        FileAlterationObserver observer = new FileAlterationObserver(directory, (FileFilter)TrueFileFilter.INSTANCE);
        observer.addListener((FileAlterationListener)new FileMonitor(directory));
        LOGGER.debug("Creating file alteration monitor for " + directory.getAbsolutePath() + " with a polling period " + "of " + polling);
        FileAlterationMonitor monitor = new FileAlterationMonitor(polling, new FileAlterationObserver[]{observer});
        monitor.setThreadFactory((ThreadFactory)new MonitorThreadFactory(directory));
        this.monitors.put(directory, monitor);
        return monitor;
    }

    private void openDeployers(File directory) {
        Collection files = FileUtils.listFiles((File)directory, null, (boolean)true);
        for (Deployer deployer : this.deployers) {
            List<File> accepted = this.getAcceptedFilesByTheDeployer(files, deployer);
            LOGGER.info("Opening deployer {} for directory {}.", (Object)deployer, (Object)directory.getAbsolutePath());
            deployer.open(accepted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAndStopIfNeeded(File directory) {
        try {
            this.acquireWriteLockIfNotHeld();
            FileAlterationMonitor monitor = this.monitors.remove(directory);
            if (monitor != null) {
                try {
                    monitor.stop();
                }
                catch (IllegalStateException e) {
                    LOGGER.warn("Stopping an already stopped file monitor on {}.", (Object)directory.getAbsolutePath());
                    LOGGER.debug(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    LOGGER.error("Something bad happened while trying to stop the file monitor on {}", (Object)directory, (Object)e);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseWriteLockIfHeld();
        }
    }

    private class FileMonitor
    extends FileAlterationListenerAdaptor {
        private final File directory;

        public FileMonitor(File directory) {
            this.directory = directory;
        }

        public void onFileCreate(File file) {
            LOGGER.info("File " + file + " created in " + this.directory);
            List depl = DirectoryMonitor.this.getDeployersAcceptingFile(file);
            LOGGER.debug("Deployer handling creation of " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileCreate(file);
                }
                catch (Exception e) {
                    LOGGER.error("Error during the management of {} (creation) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }

        public void onFileChange(File file) {
            LOGGER.info("File " + file + " from " + this.directory + " changed");
            List depl = DirectoryMonitor.this.getDeployersAcceptingFile(file);
            LOGGER.debug("Deployers handling change in " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileChange(file);
                }
                catch (Exception e) {
                    LOGGER.error("Error during the management of {} (change) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }

        public void onFileDelete(File file) {
            LOGGER.info("File " + file + " deleted from " + this.directory);
            List depl = DirectoryMonitor.this.getDeployersAcceptingFile(file);
            LOGGER.debug("Deployer handling deletion of " + file.getName() + " : " + depl);
            for (Deployer deployer : depl) {
                try {
                    deployer.onFileDelete(file);
                }
                catch (Exception e) {
                    LOGGER.error("Error during the management of {} (deletion) by {}", new Object[]{file.getAbsolutePath(), deployer, e});
                }
            }
        }
    }
}

