/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.utils;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.chameleon.core.utils.Pckg;

public class JarScanner {
    static final Pattern FUZZY_VERSION = Pattern.compile(".*-(\\d+)(\\.(\\d+)(\\.(\\d+))?)?([^a-zA-Z0-9](.*))?.jar", 32);

    public static String version(String name) {
        StringBuilder result = new StringBuilder();
        Matcher m = FUZZY_VERSION.matcher(name);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(3);
            String micro = m.group(5);
            String qualifier = m.group(7);
            if (major != null) {
                result.append(major);
                if (minor != null) {
                    result.append(".");
                    result.append(minor);
                    if (micro != null) {
                        result.append(".");
                        result.append(micro);
                        if (qualifier != null) {
                            result.append(".");
                            JarScanner.cleanupModifier(result, qualifier);
                        }
                    } else if (qualifier != null) {
                        result.append(".0.");
                        JarScanner.cleanupModifier(result, qualifier);
                    } else {
                        result.append(".0");
                    }
                } else if (qualifier != null) {
                    result.append(".0.0.");
                    JarScanner.cleanupModifier(result, qualifier);
                } else {
                    result.append(".0.0");
                }
            }
        } else {
            return null;
        }
        return result.toString();
    }

    static void cleanupModifier(StringBuilder result, String modifier) {
        for (int i = 0; i < modifier.length(); ++i) {
            char c = modifier.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '-') {
                result.append(c);
                continue;
            }
            result.append('_');
        }
    }

    public static Set<Pckg> scan(JarFile jar, String version) {
        Enumeration<JarEntry> entries = jar.entries();
        HashSet<Pckg> packages = new HashSet<Pckg>();
        while (entries.hasMoreElements()) {
            Pckg pckg;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || entry.getName().startsWith("META-INF") || (pckg = JarScanner.toPackage(entry, version)) == null) continue;
            packages.add(pckg);
        }
        return packages;
    }

    public static Set<Pckg> scan(File jarFile) throws IOException {
        if (!jarFile.getName().endsWith(".jar")) {
            return null;
        }
        String version = JarScanner.version(jarFile.getName());
        if (version == null) {
            version = "0.0.0";
        }
        JarFile jar = new JarFile(jarFile);
        return JarScanner.scan(jar, version);
    }

    private static Pckg toPackage(JarEntry entry, String version) {
        String name = entry.getName();
        if (!name.contains("/")) {
            return null;
        }
        String dir = name.substring(0, name.lastIndexOf("/"));
        return new Pckg(dir.replace("/", "."), version);
    }
}

