/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.felix.ipojo.extender.queue.QueueService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.ow2.chameleon.core.services.AbstractStabilityChecker;
import org.ow2.chameleon.core.services.StabilityResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPojoProcessingStabilityChecker
extends AbstractStabilityChecker {
    private static final int MAX_TRIES = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(IPojoProcessingStabilityChecker.class);
    private final BundleContext context;

    public IPojoProcessingStabilityChecker(BundleContext context) {
        this.context = context;
    }

    @Override
    public String getName() {
        return "iPOJO Processing Stability";
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public StabilityResult check() {
        int count = 0;
        try {
            Collection refs = this.context.getServiceReferences(QueueService.class, null);
            ArrayList<Object> queues = new ArrayList<Object>();
            for (ServiceReference ref : refs) {
                queues.add(this.context.getService(ref));
            }
            boolean emptiness = false;
            while (!emptiness && count < 500) {
                emptiness = IPojoProcessingStabilityChecker.areAllQueuesEmpty(queues);
                if (!emptiness) {
                    this.grace(500L, TimeUnit.MILLISECONDS);
                }
                ++count;
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        if (count == 500) {
            LOGGER.error("iPOJO processing queues are not empty after 500 tries");
            return StabilityResult.unstable("iPOJO Processing Queues are not empty");
        }
        return StabilityResult.stable();
    }

    private static boolean areAllQueuesEmpty(List<Object> queues) {
        boolean empty = true;
        for (Object q : queues) {
            try {
                Method currents = q.getClass().getMethod("getCurrents", new Class[0]);
                Method waiters = q.getClass().getMethod("getWaiters", new Class[0]);
                int cur = (Integer)currents.invoke(q, new Object[0]);
                int wai = (Integer)waiters.invoke(q, new Object[0]);
                LOGGER.debug("queue: " + q + " #current : " + cur + " / #waiting : " + wai);
                empty = empty && cur == 0 && wai == 0;
            }
            catch (Exception e) {
                LOGGER.error("Cannot analyze queue's metrics for {}", q, (Object)e);
                throw new IllegalArgumentException("Cannot analyze queue's metrics", e);
            }
        }
        return empty;
    }
}

