/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.hook;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.ServiceLoader;
import org.ow2.chameleon.core.ChameleonConfiguration;
import org.ow2.chameleon.core.hook.Hook;

public class HookManager {
    Collection<Hook> hooks = Collections.emptyList();

    public synchronized Collection<Hook> addHook(Hook hook) {
        this.hooks = new ImmutableList.Builder().addAll(this.hooks).add((Object)hook).build();
        return this.hooks;
    }

    public synchronized void load() {
        ServiceLoader<Hook> loader = ServiceLoader.load(Hook.class);
        for (Hook hook : loader) {
            this.addHook(hook);
        }
    }

    public void fireInitializing() {
        for (Hook hook : this.hooks) {
            hook.initializing();
        }
    }

    public void fireConfigured(ChameleonConfiguration configuration) {
        for (Hook hook : this.hooks) {
            hook.configured(configuration);
        }
    }

    public void fireShuttingDown() {
        for (Hook hook : this.hooks) {
            hook.shuttingDown();
        }
    }
}

