/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.ow2.chameleon.core.utils.BundleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreActivator
implements BundleActivator {
    private final boolean interactive;
    private final File directory;
    private static final Logger LOGGER = LoggerFactory.getLogger(CoreActivator.class);
    private BundleContext context;

    public CoreActivator(File directory, boolean interactive) {
        this.directory = directory;
        this.interactive = interactive;
    }

    public void installBundles() {
        Collection files = FileUtils.listFiles((File)this.directory, (String[])new String[]{"jar"}, (boolean)true);
        ArrayList<Bundle> toStart = new ArrayList<Bundle>();
        for (File file : files) {
            if (!BundleHelper.isBundle(file) || this.isInteractiveShell(file) && !this.interactive) continue;
            this.install(toStart, file);
        }
        for (Bundle bundle : toStart) {
            try {
                LOGGER.debug("Starting bundle {}", (Object)bundle.getSymbolicName());
                bundle.start();
            }
            catch (BundleException e) {
                LOGGER.error("Error when start bundle {}", (Object)bundle.getSymbolicName(), (Object)e);
            }
        }
    }

    private void install(List<Bundle> toStart, File file) {
        try {
            LOGGER.debug("Installing bundle from {}", (Object)file.getAbsolutePath());
            Bundle bundle = this.context.installBundle("reference:" + file.toURI().toURL().toExternalForm());
            if (!BundleHelper.isFragment(bundle)) {
                toStart.add(bundle);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error when install bundle from {}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }

    private boolean isInteractiveShell(File file) {
        return file.getName().startsWith("shelbie-startup-console");
    }

    public void start(BundleContext context) {
        this.context = context;
        this.installBundles();
    }

    public void stop(BundleContext context) {
    }
}

