/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogActivator
implements LogListener,
BundleActivator,
ServiceListener {
    private final Logger logger;
    private ServiceReference logService;
    private BundleContext context;

    public LogActivator(Logger logger) {
        this.logger = logger;
    }

    synchronized ServiceReference getLogServiceReference() {
        return this.logService;
    }

    public synchronized void setLogServiceReference(ServiceReference ref) {
        this.logService = ref;
    }

    public void logged(LogEntry le) {
        String message = le.getMessage();
        Logger log = this.logger;
        if (le.getBundle() != null) {
            log = LoggerFactory.getLogger((String)le.getBundle().getSymbolicName());
        }
        message = this.enhanceMessage(le, message);
        switch (le.getLevel()) {
            case 4: {
                this.debug(le, message, log);
                break;
            }
            case 3: {
                this.info(le, message, log);
                break;
            }
            case 2: {
                this.warn(le, message, log);
                break;
            }
            case 1: {
                this.error(le, message, log);
                break;
            }
        }
    }

    private void error(LogEntry le, String message, Logger logger) {
        if (le.getException() != null) {
            logger.error(message, le.getException());
        } else {
            logger.error(message);
        }
    }

    private void warn(LogEntry le, String message, Logger logger) {
        if (le.getException() != null) {
            logger.warn(message, le.getException());
        } else {
            logger.warn(message);
        }
    }

    private void info(LogEntry le, String message, Logger logger) {
        if (le.getException() != null) {
            logger.info(message, le.getException());
        } else {
            logger.info(message);
        }
    }

    private void debug(LogEntry le, String message, Logger logger) {
        if (le.getException() != null) {
            logger.debug(message, le.getException());
        } else {
            logger.debug(message);
        }
    }

    private String enhanceMessage(LogEntry le, String message) {
        if (le.getServiceReference() != null) {
            if (le.getServiceReference().getProperty("service.pid") != null) {
                return message + " [ServicePID=" + le.getServiceReference().getProperty("service.pid") + "]";
            }
            return message + " [ServiceID=" + le.getServiceReference().getProperty("service.id") + "]";
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        LogActivator logActivator = this;
        synchronized (logActivator) {
            this.context = bc;
            this.context.addServiceListener((ServiceListener)this, "(objectClass=" + LogReaderService.class.getName() + ")");
            this.logService = this.context.getServiceReference(LogReaderService.class.getName());
            if (this.logService != null) {
                LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
                reader.addLogListener((LogListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bc) throws Exception {
        if (bc != null) {
            bc.removeServiceListener((ServiceListener)this);
            LogActivator logActivator = this;
            synchronized (logActivator) {
                if (this.logService != null) {
                    LogReaderService reader = (LogReaderService)bc.getService(this.logService);
                    reader.removeLogListener((LogListener)this);
                    this.logService = null;
                }
            }
        }
    }

    public synchronized void serviceChanged(ServiceEvent ev) {
        if (this.logService == null && ev.getType() == 1) {
            this.logService = ev.getServiceReference();
            LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
            reader.addLogListener((LogListener)this);
            return;
        }
        if (this.logService != null && ev.getType() == 4 && this.logService == ev.getServiceReference()) {
            LogReaderService reader = (LogReaderService)this.context.getService(this.logService);
            reader.removeLogListener((LogListener)this);
            this.logService = null;
        }
    }
}

