/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.launch.Framework;
import org.ow2.chameleon.core.ChameleonConfiguration;
import org.ow2.chameleon.core.activators.BundleDeployer;
import org.ow2.chameleon.core.activators.ConfigDeployer;
import org.ow2.chameleon.core.activators.CoreActivator;
import org.ow2.chameleon.core.activators.DirectoryMonitor;
import org.ow2.chameleon.core.activators.LogActivator;
import org.ow2.chameleon.core.activators.StabilityComputation;
import org.ow2.chameleon.core.hook.HookManager;
import org.ow2.chameleon.core.services.Stability;
import org.ow2.chameleon.core.utils.FrameworkManager;
import org.ow2.chameleon.core.utils.LogbackUtil;
import org.ow2.chameleon.core.utils.jul.JulLogManager;
import org.slf4j.Logger;

public class Chameleon {
    public static final String CHAMELEON_BASEDIR = "chameleon.base";
    private final FrameworkManager manager;
    private final Logger logger;
    private List<BundleActivator> activators = new ArrayList<BundleActivator>();
    private final HookManager hooks;

    public Chameleon(File basedir, boolean interactive, Map<String, Object> userProperties) throws IOException {
        if (System.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", JulLogManager.class.getName());
        }
        this.hooks = new HookManager();
        this.hooks.load();
        this.hooks.fireInitializing();
        ChameleonConfiguration configuration = new ChameleonConfiguration(basedir);
        configuration.setInteractiveModeEnabled(interactive);
        configuration.initialize(userProperties);
        configuration.initFrameworkConfiguration();
        this.logger = Chameleon.initializeLoggingSystem(configuration);
        this.initializeActivatorList(configuration);
        this.manager = new FrameworkManager(this, configuration);
        this.manager.addActivators(this.activators);
    }

    public Chameleon(ChameleonConfiguration configuration) throws IOException {
        if (System.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", JulLogManager.class.getName());
        }
        this.hooks = new HookManager();
        this.hooks.load();
        this.hooks.fireInitializing();
        configuration.setInteractiveModeEnabled(false);
        configuration.initialize(null);
        configuration.initFrameworkConfiguration();
        this.logger = Chameleon.initializeLoggingSystem(configuration);
        this.initializeActivatorList(configuration);
        this.manager = new FrameworkManager(this, configuration);
        this.manager.addActivators(this.activators);
    }

    public Chameleon(boolean interactive) throws IOException {
        this(System.getProperty(CHAMELEON_BASEDIR) != null ? new File(System.getProperty(CHAMELEON_BASEDIR)) : new File(""), interactive, null);
    }

    public Chameleon(String basedir, boolean interactive) throws IOException {
        this(new File(basedir), interactive, null);
    }

    public Chameleon(boolean interactive, Map<String, Object> userProperties) throws IOException {
        this(System.getProperty(CHAMELEON_BASEDIR) != null ? new File(System.getProperty(CHAMELEON_BASEDIR)) : new File(""), interactive, userProperties);
    }

    public static Logger initializeLoggingSystem(ChameleonConfiguration configuration) {
        Logger log = LogbackUtil.configure(configuration);
        if (configuration.isInteractiveModeEnabled()) {
            log.debug("interactive mode enabled");
        }
        return log;
    }

    private void initializeActivatorList(ChameleonConfiguration configuration) {
        File core = configuration.getDirectory("chameleon.core", true);
        if (core == null) {
            throw new IllegalArgumentException("The chameleon.core property is missing in the conf/chameleon.properties file.");
        }
        File runtime = configuration.getDirectory("chameleon.runtime", true);
        if (runtime == null) {
            throw new IllegalArgumentException("The chameleon.runtime property is missing in the conf/chameleon.properties file.");
        }
        File application = configuration.getDirectory("chameleon.application", true);
        if (application == null) {
            throw new IllegalArgumentException("The chameleon.application property is missing in the conf/chameleon.properties file.");
        }
        this.activators.add(new LogActivator(this.logger));
        this.activators.add(new CoreActivator(core, configuration.isInteractiveModeEnabled()));
        DirectoryMonitor monitor = new DirectoryMonitor();
        this.activators.add(monitor);
        boolean monitoringRuntime = configuration.getBoolean("chameleon.runtime.monitoring", false);
        boolean monitoringApplication = configuration.getBoolean("chameleon.application.monitoring", true);
        int monitoringPeriod = configuration.getInt("chameleon.monitoring.period", 2000);
        if (monitoringRuntime) {
            monitor.add(runtime, monitoringPeriod);
        } else {
            monitor.add(runtime, false);
        }
        if (monitoringApplication) {
            monitor.add(application, monitoringPeriod);
        } else {
            monitor.add(application, false);
        }
        this.activators.add(new BundleDeployer(false));
        this.activators.add(new ConfigDeployer());
        this.activators.add(new StabilityComputation());
    }

    public Chameleon start() throws BundleException {
        this.hooks.fireConfigured(this.manager.configuration());
        this.manager.start();
        return this;
    }

    public Chameleon waitForStability() {
        ServiceReference reference = this.context().getServiceReference(Stability.class);
        if (reference == null) {
            throw new IllegalStateException("Cannot reach stability - stability service missing");
        }
        Stability stability = (Stability)this.context().getService(reference);
        if (!stability.waitForStability()) {
            throw new IllegalStateException("Cannot reach stability");
        }
        return this;
    }

    public Chameleon stop() throws BundleException, InterruptedException {
        this.logger.info("Stopping Chameleon");
        this.manager.stop();
        this.logger.info("Chameleon stopped");
        this.hooks.fireShuttingDown();
        return this;
    }

    public BundleContext context() {
        return this.manager.get().getBundleContext();
    }

    public Framework framework() {
        return this.manager.get();
    }
}

