/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.ow2.chameleon.core.services.AbstractStabilityChecker;
import org.ow2.chameleon.core.services.StabilityResult;
import org.ow2.chameleon.core.utils.BundleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleStabilityChecker
extends AbstractStabilityChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleStabilityChecker.class);
    private final BundleContext context;
    private final int attempts;

    public BundleStabilityChecker(BundleContext context) {
        this(context, BundleStabilityChecker.getDefaultNumberOfAttempts());
    }

    public BundleStabilityChecker(BundleContext context, int max) {
        this.context = context;
        this.attempts = max;
    }

    @Override
    public String getName() {
        return "Bundle Stability";
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public StabilityResult check() {
        int count;
        boolean bundleStability = BundleStabilityChecker.getBundleStability(this.context);
        for (count = 0; !bundleStability && count < this.attempts; ++count) {
            BundleStabilityChecker.grace();
            bundleStability = BundleStabilityChecker.getBundleStability(this.context);
        }
        if (count == this.attempts) {
            LOGGER.error("Bundle stability isn't reached after {} tries", (Object)this.attempts);
            for (Bundle bundle : this.context.getBundles()) {
                LOGGER.error("Bundle {} - {} -> {}", new Object[]{bundle.getBundleId(), bundle.getSymbolicName(), bundle.getState()});
            }
            return StabilityResult.unstable("Cannot reach the bundle stability");
        }
        return StabilityResult.stable();
    }

    public static boolean getBundleStability(BundleContext bc) {
        Bundle[] bundles;
        boolean stability = true;
        for (Bundle bundle : bundles = bc.getBundles()) {
            stability = BundleHelper.isFragment(bundle) ? stability && bundle.getState() == 4 : stability && bundle.getState() == 32;
        }
        return stability;
    }
}

