/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.services;

public class StabilityResult {
    public final boolean isStable;
    public final String reason;
    public final Throwable cause;

    private StabilityResult(String reason, Throwable cause) {
        this.isStable = reason == null && cause == null;
        this.cause = cause;
        this.reason = reason != null ? reason : (cause != null ? cause.getMessage() : null);
    }

    public static StabilityResult stable() {
        return new StabilityResult(null, null);
    }

    public static StabilityResult notAvailable() {
        return new StabilityResult("Not Run", null);
    }

    public static StabilityResult unstable(String reason) {
        return StabilityResult.unstable(reason, null);
    }

    public static StabilityResult unstable(Throwable cause) {
        return StabilityResult.unstable(null, cause);
    }

    public static StabilityResult unstable(String reason, Throwable cause) {
        return new StabilityResult(reason, cause);
    }
}

