/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.ow2.chameleon.core.services.AbstractDeployer;
import org.ow2.chameleon.core.services.Deployer;
import org.ow2.chameleon.core.utils.BundleHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDeployer
extends AbstractDeployer
implements BundleActivator {
    public static final String REFERENCE_URL_PREFIX = "reference:";
    private final boolean useReference;
    private final boolean autoRefresh;
    Map<File, Bundle> bundles = new HashMap<File, Bundle>();
    private BundleContext context;
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleDeployer.class);

    public BundleDeployer(boolean useReferences, boolean autoRefresh) {
        this.autoRefresh = autoRefresh;
        this.useReference = useReferences;
    }

    public void start(BundleContext context) {
        this.context = context;
        context.registerService(Deployer.class, (Object)this, null);
    }

    public void stop(BundleContext context) {
    }

    @Override
    public boolean accept(File file) {
        return file.getName().endsWith(".jar") && (!file.isFile() || BundleHelper.isBundle(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileCreate(File file) {
        LOGGER.debug("File creation event received for {}", (Object)file.getAbsoluteFile());
        BundleDeployer bundleDeployer = this;
        synchronized (bundleDeployer) {
            if (this.bundles.containsKey(file)) {
                Bundle bundle = this.bundles.get(file);
                LOGGER.info("Updating bundle {} - {}", (Object)bundle.getSymbolicName(), (Object)file.getAbsoluteFile());
                try {
                    bundle.update();
                    this.refresh();
                    this.tryToStartUnstartedBundles(bundle);
                    if (bundle.getState() != 32 && !BundleHelper.isFragment(bundle)) {
                        bundle.start();
                    }
                }
                catch (BundleException e) {
                    LOGGER.error("Error during bundle update {} from {}", new Object[]{bundle.getSymbolicName(), file.getAbsoluteFile(), e});
                }
                catch (IllegalStateException e) {
                    LOGGER.error("Cannot update the bundle " + file.getAbsolutePath() + " - the framework is either " + "stopping or restarting");
                    LOGGER.debug("Invalid bundle context", (Throwable)e);
                }
            } else {
                LOGGER.info("Installing bundle from {}", (Object)file.getAbsoluteFile());
                try {
                    Bundle bundle = this.useReference ? this.context.installBundle(REFERENCE_URL_PREFIX + file.toURI().toURL().toExternalForm()) : this.context.installBundle(file.toURI().toURL().toExternalForm());
                    this.bundles.put(file, bundle);
                    if (!BundleHelper.isFragment(bundle)) {
                        LOGGER.info("Starting bundle {} - {}", (Object)bundle.getSymbolicName(), (Object)file.getAbsoluteFile());
                        bundle.start();
                    }
                    this.tryToStartUnstartedBundles(bundle);
                }
                catch (Exception e) {
                    LOGGER.error("Error during bundle installation of {}", (Object)file.getAbsoluteFile(), (Object)e);
                }
            }
        }
    }

    private void tryToStartUnstartedBundles(Bundle bundle) {
        for (Bundle b : this.bundles.values()) {
            if (bundle.equals(b) || b.getState() == 32 || BundleHelper.isFragment(b)) continue;
            LOGGER.debug("Trying to start bundle {} after having installed bundle {}", (Object)b.getSymbolicName(), (Object)bundle.getSymbolicName());
            try {
                b.start();
            }
            catch (BundleException e) {
                LOGGER.debug("Failed to start bundle {} after having installed bundle {}", new Object[]{b.getSymbolicName(), bundle.getSymbolicName(), e});
            }
        }
    }

    @Override
    public void open(Collection<File> files) {
        ArrayList<Bundle> toStart = new ArrayList<Bundle>();
        for (File file : files) {
            try {
                Bundle bundle = this.useReference ? this.context.installBundle(REFERENCE_URL_PREFIX + file.toURI().toURL().toExternalForm()) : this.context.installBundle(file.toURI().toURL().toExternalForm());
                this.bundles.put(file, bundle);
                if (BundleHelper.isFragment(bundle)) continue;
                toStart.add(bundle);
            }
            catch (Exception e) {
                LOGGER.error("Error during bundle installation of {}", (Object)file.getAbsoluteFile(), (Object)e);
            }
        }
        for (Bundle bundle : toStart) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                LOGGER.error("Error during the starting of {}", (Object)bundle.getSymbolicName(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileDelete(File file) {
        Bundle bundle;
        BundleDeployer bundleDeployer = this;
        synchronized (bundleDeployer) {
            bundle = this.bundles.remove(file);
        }
        if (bundle != null) {
            try {
                LOGGER.info("Uninstalling bundle {}", (Object)bundle.getSymbolicName());
                bundle.uninstall();
                this.refresh();
            }
            catch (BundleException e) {
                LOGGER.error("Error during the un-installation of {}", (Object)bundle.getSymbolicName(), (Object)e);
            }
        }
    }

    public void refresh() {
        if (this.autoRefresh) {
            Bundle system = this.context.getBundle(0L);
            FrameworkWiring wiring = (FrameworkWiring)system.adapt(FrameworkWiring.class);
            LOGGER.debug("Refreshing bundles to cleanup stale references");
            wiring.refreshBundles(null, new FrameworkListener[]{new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getThrowable() != null) {
                        LOGGER.error("An error was detected while refreshing the bundles", event.getThrowable());
                    }
                }
            }});
        }
    }
}

