/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.activators;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.chameleon.core.activators.BundleStabilityChecker;
import org.ow2.chameleon.core.activators.IPojoProcessingStabilityChecker;
import org.ow2.chameleon.core.activators.ServiceStabilityChecker;
import org.ow2.chameleon.core.services.Stability;
import org.ow2.chameleon.core.services.StabilityChecker;
import org.ow2.chameleon.core.services.StabilityResult;
import org.ow2.chameleon.core.utils.BundleHelper;

public class StabilityComputation
implements BundleActivator,
Stability {
    private BundleContext context;
    private ServiceRegistration<Stability> reg;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.reg = context.registerService(Stability.class, (Object)this, null);
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
        BundleHelper.unregisterQuietly(this.reg);
    }

    private Set<StabilityChecker> getCheckers() {
        Collection<Object> references;
        try {
            references = this.context.getServiceReferences(StabilityChecker.class, null);
        }
        catch (InvalidSyntaxException e) {
            references = Collections.emptyList();
        }
        TreeSet<StabilityChecker> checkers = new TreeSet<StabilityChecker>(new Comparator<StabilityChecker>(){

            @Override
            public int compare(StabilityChecker o1, StabilityChecker o2) {
                return Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
            }
        });
        for (ServiceReference serviceReference : references) {
            checkers.add((StabilityChecker)this.context.getService(serviceReference));
        }
        checkers.add(new BundleStabilityChecker(this.context));
        checkers.add(new ServiceStabilityChecker(this.context));
        checkers.add(new IPojoProcessingStabilityChecker(this.context));
        return checkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStable() {
        long originalGraceTimeInMillis = Long.getLong("stability.grace", -1L);
        int originalNumberOfAttempts = Integer.getInteger("stability.attempts", -1);
        try {
            System.setProperty("stability.grace", "3");
            System.setProperty("stability.attempts", "3");
            boolean bl = this.waitForStability();
            return bl;
        }
        finally {
            if (originalGraceTimeInMillis != -1L) {
                System.setProperty("stability.grace", Long.toString(originalGraceTimeInMillis));
            } else {
                System.clearProperty("stability.grace");
            }
            if (originalNumberOfAttempts != -1) {
                System.setProperty("stability.attempts", Integer.toString(originalNumberOfAttempts));
            } else {
                System.clearProperty("stability.attempts");
            }
        }
    }

    @Override
    public boolean waitForStability() {
        Map<StabilityChecker, StabilityResult> results = this.getStabilityResult();
        for (StabilityResult result : results.values()) {
            if (result.isStable) continue;
            return false;
        }
        return true;
    }

    @Override
    public Map<StabilityChecker, StabilityResult> getStabilityResult() {
        Set<StabilityChecker> checkers = this.getCheckers();
        LinkedHashMap<StabilityChecker, StabilityResult> results = new LinkedHashMap<StabilityChecker, StabilityResult>();
        boolean hasNotBeenReached = false;
        for (StabilityChecker checker : checkers) {
            if (hasNotBeenReached) {
                results.put(checker, StabilityResult.notAvailable());
                continue;
            }
            StabilityResult sr = checker.check();
            results.put(checker, sr);
            hasNotBeenReached = !sr.isStable;
        }
        return results;
    }
}

