/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.services;

import java.util.concurrent.TimeUnit;
import org.ow2.chameleon.core.services.StabilityChecker;

public abstract class AbstractStabilityChecker
implements StabilityChecker {
    public static final String TIME_FACTOR = "time.factor";
    public static final String STABILITY_GRACE = "stability.grace";
    public static final String STABILITY_ATTEMPTS = "stability.attempts";

    public static int getTimeFactor() {
        return Integer.getInteger(TIME_FACTOR, 1);
    }

    public static long getDefaultGracePeriodInMillis() {
        return Long.getLong(STABILITY_GRACE, 100L);
    }

    public static int getDefaultNumberOfAttempts() {
        return Integer.getInteger(STABILITY_ATTEMPTS, 500);
    }

    public static void grace() {
        AbstractStabilityChecker.grace(AbstractStabilityChecker.getDefaultGracePeriodInMillis(), TimeUnit.MILLISECONDS);
    }

    public static void grace(long amount, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(amount) * (long)AbstractStabilityChecker.getTimeFactor());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

