/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.launch.FrameworkFactory;
import org.ow2.chameleon.core.utils.FrameworkClassLoader;

public final class FrameworkUtil {
    public static final String FRAMEWORK_FACTORY = "META-INF/services/org.osgi.framework.launch.FrameworkFactory";

    private FrameworkUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameworkFactory getFrameworkFactory(File basedir, Map<String, String> configuration) throws ClassNotFoundException, IllegalAccessException, InstantiationException, IOException {
        ClassLoader classLoader = FrameworkClassLoader.getFrameworkClassLoader(basedir, configuration);
        URL url = classLoader.getResource(FRAMEWORK_FACTORY);
        if (url != null) {
            InputStream stream = null;
            try {
                stream = url.openStream();
                String content = FrameworkUtil.read(stream);
                if (content == null) {
                    throw new IOException("Could not read the framework factory service file (META-INF/services/org.osgi.framework.launch.FrameworkFactory), or the file is empty");
                }
                FrameworkFactory frameworkFactory = (FrameworkFactory)classLoader.loadClass(content).newInstance();
                return frameworkFactory;
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        throw new IOException("Cannot find the framework factory service file (META-INF/services/org.osgi.framework.launch.FrameworkFactory), check that you have an OSGi implementation in your classpath.");
    }

    public static Framework create(File baseDir, Map<String, String> configuration) throws IOException {
        try {
            return FrameworkUtil.getFrameworkFactory(baseDir, configuration).newFramework(configuration);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot load the OSGi framework", e);
        }
        catch (IllegalAccessException e) {
            throw new IOException("Cannot initialize the OSGi framework", e);
        }
        catch (InstantiationException e) {
            throw new IOException("Cannot instantiate the OSGi framework", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        try {
            List lines = IOUtils.readLines((InputStream)stream);
            for (String line : lines) {
                String l = line.trim();
                if (l.isEmpty() || l.startsWith("#")) continue;
                String string = l;
                return string;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }
}

