/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.core.utils.jul;

import ch.qos.logback.classic.LoggerContext;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.ow2.chameleon.core.utils.jul.JulLevels;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class JulWrapper
extends Logger {
    private static LoggerContext loggerContext;
    private final ch.qos.logback.classic.Logger logger;

    protected JulWrapper(String name) {
        super(name, null);
        this.logger = loggerContext.getLogger(name);
        super.setLevel(JulLevels.toJUL(this.logger.getEffectiveLevel()));
    }

    @Override
    public void log(LogRecord record) {
        if (record == null || record.getMessage() == null) {
            return;
        }
        ch.qos.logback.classic.Level level = JulLevels.toSlf4J(record.getLevel());
        if (this.logger.isEnabledFor(level)) {
            String message = record.getMessage();
            try {
                Object[] parameters = record.getParameters();
                if (parameters != null && parameters.length != 0) {
                    message = MessageFormat.format(message, parameters);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.logger.log(null, ch.qos.logback.classic.Logger.FQCN, ch.qos.logback.classic.Level.toLocationAwareLoggerInteger((ch.qos.logback.classic.Level)level), message, null, record.getThrown());
        }
    }

    @Override
    public void setLevel(Level newLevel) {
        this.logger.setLevel(JulLevels.toSlf4J(newLevel));
        super.setLevel(newLevel);
    }

    @Override
    public Level getLevel() {
        ch.qos.logback.classic.Level level = this.logger.getLevel();
        if (level == null) {
            return null;
        }
        return JulLevels.toJUL(level);
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.logger.isEnabledFor(JulLevels.toSlf4J(level));
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    @Override
    public void log(Level level, String msg) {
        ch.qos.logback.classic.Level logbackLevel = JulLevels.toSlf4J(level);
        this.logger.log(null, ch.qos.logback.classic.Logger.FQCN, ch.qos.logback.classic.Level.toLocationAwareLoggerInteger((ch.qos.logback.classic.Level)logbackLevel), msg, null, null);
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        ch.qos.logback.classic.Level logbackLevel = JulLevels.toSlf4J(level);
        if (this.logger.isEnabledFor(logbackLevel)) {
            String fmtMsg = MessageFormat.format(msg, param1);
            this.logger.log(null, ch.qos.logback.classic.Logger.FQCN, ch.qos.logback.classic.Level.toLocationAwareLoggerInteger((ch.qos.logback.classic.Level)logbackLevel), fmtMsg, null, null);
        }
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        ch.qos.logback.classic.Level logbackLevel = JulLevels.toSlf4J(level);
        if (this.logger.isEnabledFor(logbackLevel)) {
            String fmtMsg = MessageFormat.format(msg, params);
            this.logger.log(null, ch.qos.logback.classic.Logger.FQCN, ch.qos.logback.classic.Level.toLocationAwareLoggerInteger((ch.qos.logback.classic.Level)logbackLevel), fmtMsg, null, null);
        }
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        ch.qos.logback.classic.Level logbackLevel = JulLevels.toSlf4J(level);
        this.logger.log(null, ch.qos.logback.classic.Logger.FQCN, ch.qos.logback.classic.Level.toLocationAwareLoggerInteger((ch.qos.logback.classic.Level)logbackLevel), msg, null, thrown);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logger.error(sourceClass + '.' + sourceMethod, thrown);
    }

    @Override
    public void severe(String msg) {
        this.logger.error(msg);
    }

    @Override
    public void warning(String msg) {
        this.logger.warn(msg);
    }

    @Override
    public void info(String msg) {
        this.logger.info(msg);
    }

    @Override
    public void config(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void fine(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void finer(String msg) {
        this.logger.trace(msg);
    }

    @Override
    public void finest(String msg) {
        this.logger.trace(msg);
    }

    static {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (factory instanceof LoggerContext) {
            loggerContext = (LoggerContext)factory;
        } else {
            loggerContext = new LoggerContext();
            loggerContext.setName("default");
        }
    }
}

