/*
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.chat;

import java.util.List;
import java.util.Map;

/**
 * Discussion provides the method to receive and send messages.
 * @author <a href="mailto:chameleon-dev@ow2.org">Chameleon Project Team</a>
 * @version 1.0.0
 */
public interface Discussion {

    /**
     * Sends a message to the discussion.
     * @param message the message
     * @throws Exception if the message cannot be delivered
     */
    public void sendMessage(String message) throws Exception;

    /**
     * Sends a message to the discussion. The message comes with a
     * set of properties (implementation dependent)
     * @param message the message
     * @param props the properties
     * @throws Exception if the message cannot be delivered
     */
    public void sendMessage(String message, Map<String, ?> props) throws Exception;

    /**
     * Registers a message listener for this discussion.
     * Message Receivers are notified when a new message is sent to the discussion.
     * @param receiver the message receiver
     */
    public void registerMessageReceiver(MessageReceiver receiver);

    /**
     * Removes a message receiver.
     * @param receiver the message receiver
     */
    public void unregisterMessageReceiver(MessageReceiver receiver);

    /**
     * Closes the discussion.
     */
    public void close();

    /**
     * Gets the list of participants
     * @return the list of the participants
     */
    public List<String> getParticipants();


}
