/*
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.chat;

import java.util.List;

/**
 * Discussion listeners are notified when a new conversation is opened
 * by a (remote) contact.
 * @author <a href="mailto:chameleon-dev@ow2.org">Chameleon Project Team</a>
 * @version 1.0.0
 */
public interface DiscussionListener {

    /**
     * Callback called when a new discussion is opened.
     * @param newDiscussion the new conversation object
     * @param participants the list of participants
     */
    public void onNewDiscussion(Discussion newDiscussion, List<String> participants);

}
