/*
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.chat;

import java.util.Map;

/**
 * Message receivers are notified when a new message is sent to the
 * listened conversation.
 * @author <a href="mailto:chameleon-dev@ow2.org">Chameleon Project Team</a>
 * @version 1.0.0
 */
public interface MessageReceiver {

    /**
     * Callback called when a new message is sent.
     * @param conversation the conversation
     * @param from the contact sending the message
     * @param message the message
     * @param properties the properties (may be <code>null</code>)
     */
    public void onReceivedMessage(Discussion conversation, String from, String message, Map<String, Object> properties);

}
