/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.messaging.jabber.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Provides;
import org.apache.felix.ipojo.annotations.ServiceProperty;
import org.apache.felix.ipojo.annotations.Validate;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.ow2.chameleon.chat.ChatService;
import org.ow2.chameleon.chat.ContactListener;
import org.ow2.chameleon.chat.Discussion;
import org.ow2.chameleon.chat.DiscussionListener;
import org.ow2.chameleon.messaging.jabber.impl.DiscussionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.ow2.chameleon.chat.jabber")
@Provides(specifications={ChatService.class})
public class JabberConnector
implements ConnectionListener,
ChatService,
MessageListener,
ChatManagerListener,
RosterListener,
Pojo {
    private InstanceManager __IM;
    private static final int RETRY_LOGIN_TIMEOUT = 60000;
    private boolean __Fm_connection;
    private XMPPConnection m_connection;
    private boolean __Fm_logger;
    private Logger m_logger;
    private boolean __Fm_loggedIn;
    @ServiceProperty(name="org.ow2.chameleon.chat.connected", value="false")
    private volatile boolean m_loggedIn;
    private boolean __Fm_loggingIn;
    private volatile boolean m_loggingIn;
    private boolean __Fm_connectionThread;
    private Thread m_connectionThread;
    private boolean __Fm_host;
    @Property(name="jabber.host", mandatory=true)
    private String m_host;
    private boolean __Fm_port;
    @Property(name="jabber.port", value="5222")
    private int m_port;
    private boolean __Fm_user;
    @ServiceProperty(name="org.ow2.chameleon.chat.user")
    private String m_user;
    private boolean __Fm_password;
    @Property(name="jabber.password", mandatory=true)
    private String m_password;
    private boolean __Fm_serviceName;
    @ServiceProperty(name="org.ow2.chameleon.chat.service")
    private String m_serviceName;
    private boolean __Fm_invitationPolicy;
    @Property(name="jabber.invitation")
    private String m_invitationPolicy;
    private boolean __Fm_invitation;
    private Roster.SubscriptionMode m_invitation;
    private boolean __Fm_doReconnect;
    private boolean m_doReconnect;
    private boolean __Fm_activeDiscussions;
    private HashMap<String, DiscussionImpl> m_activeDiscussions;
    private boolean __Fm_contactListeners;
    private List<ContactListener> m_contactListeners;
    private boolean __Fm_discussionListeners;
    private List<DiscussionListener> m_discussionListeners;
    private boolean __Mlogin;
    private boolean __Mlogout;
    private boolean __MisLoggedIn;
    private boolean __MisLogginInProgress;
    private boolean __MprocessMessage$org_jivesoftware_smack_Chat$org_jivesoftware_smack_packet_Message;
    private boolean __MconnectionClosed;
    private boolean __MconnectionClosedOnError$java_lang_Exception;
    private boolean __MwaitBeforeRetry;
    private boolean __M_logout;
    private boolean __M_login;
    private boolean __Mstop;
    private boolean __Mstart;
    private boolean __MreconnectingIn$int;
    private boolean __MreconnectionFailed$java_lang_Exception;
    private boolean __MreconnectionSuccessful;
    private boolean __MchatCreated$org_jivesoftware_smack_Chat$boolean;
    private boolean __MaddContactListener$org_ow2_chameleon_chat_ContactListener;
    private boolean __MgetContactList;
    private boolean __MgetDiscussion$java_lang_String;
    private boolean __MgetOnlineContactList;
    private boolean __MremoveContactListener$org_ow2_chameleon_chat_ContactListener;
    private boolean __MsetPresence$org_ow2_chameleon_chat_ChatService$Presence$java_lang_String;
    private boolean __MentriesAdded$java_util_Collection;
    private boolean __MentriesDeleted$java_util_Collection;
    private boolean __MentriesUpdated$java_util_Collection;
    private boolean __MpresenceChanged$org_jivesoftware_smack_packet_Presence;
    private boolean __MaddDiscussionListener$org_ow2_chameleon_chat_DiscussionListener;
    private boolean __MremoveDiscussionListener$org_ow2_chameleon_chat_DiscussionListener;
    private boolean __McloseDiscussion$java_lang_String$org_ow2_chameleon_messaging_jabber_impl_DiscussionImpl;
    private boolean __MsetService$java_lang_String;
    private boolean __MsetUSer$java_lang_String;

    XMPPConnection __getm_connection() {
        if (!this.__Fm_connection) {
            return this.m_connection;
        }
        return (XMPPConnection)this.__IM.onGet((Object)this, "m_connection");
    }

    void __setm_connection(XMPPConnection xMPPConnection) {
        if (!this.__Fm_connection) {
            this.m_connection = xMPPConnection;
            return;
        }
        this.__IM.onSet((Object)this, "m_connection", (Object)xMPPConnection);
    }

    Logger __getm_logger() {
        if (!this.__Fm_logger) {
            return this.m_logger;
        }
        return (Logger)this.__IM.onGet((Object)this, "m_logger");
    }

    void __setm_logger(Logger logger) {
        if (!this.__Fm_logger) {
            this.m_logger = logger;
            return;
        }
        this.__IM.onSet((Object)this, "m_logger", (Object)logger);
    }

    boolean __getm_loggedIn() {
        if (!this.__Fm_loggedIn) {
            return this.m_loggedIn;
        }
        Object object = this.__IM.onGet((Object)this, "m_loggedIn");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_loggedIn(boolean bl) {
        if (!this.__Fm_loggedIn) {
            this.m_loggedIn = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_loggedIn", (Object)bl2);
    }

    boolean __getm_loggingIn() {
        if (!this.__Fm_loggingIn) {
            return this.m_loggingIn;
        }
        Object object = this.__IM.onGet((Object)this, "m_loggingIn");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_loggingIn(boolean bl) {
        if (!this.__Fm_loggingIn) {
            this.m_loggingIn = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_loggingIn", (Object)bl2);
    }

    Thread __getm_connectionThread() {
        if (!this.__Fm_connectionThread) {
            return this.m_connectionThread;
        }
        return (Thread)this.__IM.onGet((Object)this, "m_connectionThread");
    }

    void __setm_connectionThread(Thread thread) {
        if (!this.__Fm_connectionThread) {
            this.m_connectionThread = thread;
            return;
        }
        this.__IM.onSet((Object)this, "m_connectionThread", (Object)thread);
    }

    String __getm_host() {
        if (!this.__Fm_host) {
            return this.m_host;
        }
        return (String)this.__IM.onGet((Object)this, "m_host");
    }

    void __setm_host(String string) {
        if (!this.__Fm_host) {
            this.m_host = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_host", (Object)string);
    }

    int __getm_port() {
        if (!this.__Fm_port) {
            return this.m_port;
        }
        Object object = this.__IM.onGet((Object)this, "m_port");
        Integer n = (Integer)object;
        return n;
    }

    void __setm_port(int n) {
        if (!this.__Fm_port) {
            this.m_port = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "m_port", (Object)n2);
    }

    String __getm_user() {
        if (!this.__Fm_user) {
            return this.m_user;
        }
        return (String)this.__IM.onGet((Object)this, "m_user");
    }

    void __setm_user(String string) {
        if (!this.__Fm_user) {
            this.m_user = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_user", (Object)string);
    }

    String __getm_password() {
        if (!this.__Fm_password) {
            return this.m_password;
        }
        return (String)this.__IM.onGet((Object)this, "m_password");
    }

    void __setm_password(String string) {
        if (!this.__Fm_password) {
            this.m_password = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_password", (Object)string);
    }

    String __getm_serviceName() {
        if (!this.__Fm_serviceName) {
            return this.m_serviceName;
        }
        return (String)this.__IM.onGet((Object)this, "m_serviceName");
    }

    void __setm_serviceName(String string) {
        if (!this.__Fm_serviceName) {
            this.m_serviceName = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_serviceName", (Object)string);
    }

    String __getm_invitationPolicy() {
        if (!this.__Fm_invitationPolicy) {
            return this.m_invitationPolicy;
        }
        return (String)this.__IM.onGet((Object)this, "m_invitationPolicy");
    }

    void __setm_invitationPolicy(String string) {
        if (!this.__Fm_invitationPolicy) {
            this.m_invitationPolicy = string;
            return;
        }
        this.__IM.onSet((Object)this, "m_invitationPolicy", (Object)string);
    }

    Roster.SubscriptionMode __getm_invitation() {
        if (!this.__Fm_invitation) {
            return this.m_invitation;
        }
        return (Roster.SubscriptionMode)((Object)this.__IM.onGet((Object)this, "m_invitation"));
    }

    void __setm_invitation(Roster.SubscriptionMode subscriptionMode) {
        if (!this.__Fm_invitation) {
            this.m_invitation = subscriptionMode;
            return;
        }
        this.__IM.onSet((Object)this, "m_invitation", (Object)subscriptionMode);
    }

    boolean __getm_doReconnect() {
        if (!this.__Fm_doReconnect) {
            return this.m_doReconnect;
        }
        Object object = this.__IM.onGet((Object)this, "m_doReconnect");
        Boolean bl = (Boolean)object;
        return bl;
    }

    void __setm_doReconnect(boolean bl) {
        if (!this.__Fm_doReconnect) {
            this.m_doReconnect = bl;
            return;
        }
        Boolean bl2 = new Boolean(bl);
        this.__IM.onSet((Object)this, "m_doReconnect", (Object)bl2);
    }

    HashMap __getm_activeDiscussions() {
        if (!this.__Fm_activeDiscussions) {
            return this.m_activeDiscussions;
        }
        return (HashMap)this.__IM.onGet((Object)this, "m_activeDiscussions");
    }

    void __setm_activeDiscussions(HashMap hashMap) {
        if (!this.__Fm_activeDiscussions) {
            this.m_activeDiscussions = hashMap;
            return;
        }
        this.__IM.onSet((Object)this, "m_activeDiscussions", (Object)hashMap);
    }

    List __getm_contactListeners() {
        if (!this.__Fm_contactListeners) {
            return this.m_contactListeners;
        }
        return (List)this.__IM.onGet((Object)this, "m_contactListeners");
    }

    void __setm_contactListeners(List list) {
        if (!this.__Fm_contactListeners) {
            this.m_contactListeners = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_contactListeners", (Object)list);
    }

    List __getm_discussionListeners() {
        if (!this.__Fm_discussionListeners) {
            return this.m_discussionListeners;
        }
        return (List)this.__IM.onGet((Object)this, "m_discussionListeners");
    }

    void __setm_discussionListeners(List list) {
        if (!this.__Fm_discussionListeners) {
            this.m_discussionListeners = list;
            return;
        }
        this.__IM.onSet((Object)this, "m_discussionListeners", (Object)list);
    }

    public JabberConnector() {
        this(null);
    }

    private JabberConnector(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setm_activeDiscussions(new HashMap());
        this.__setm_contactListeners(new ArrayList());
        this.__setm_discussionListeners(new ArrayList());
        this.__setm_logger(LoggerFactory.getLogger((String)this.getClass().getName()));
        this.__getm_logger().info("created " + this.getClass().getName());
        if (this.__getm_invitationPolicy() == null) {
            this.__setm_invitation(Roster.SubscriptionMode.manual);
        } else if (this.__getm_invitationPolicy().equalsIgnoreCase("accept_all")) {
            this.__setm_invitation(Roster.SubscriptionMode.accept_all);
        } else {
            this.__setm_invitation(Roster.SubscriptionMode.reject_all);
        }
    }

    public JabberConnector(String server, int port, String service, String un, String pwd, String invitation) {
        this();
        this.m_host = server;
        this.m_port = port;
        this.m_user = un;
        this.m_password = pwd;
        this.m_serviceName = service;
        this.m_invitation = invitation == null ? Roster.SubscriptionMode.manual : (invitation.equalsIgnoreCase("accept_all") ? Roster.SubscriptionMode.accept_all : Roster.SubscriptionMode.reject_all);
    }

    public void login() {
        if (!this.__Mlogin) {
            this.__login();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "login", new Object[0]);
            this.__login();
            this.__IM.onExit((Object)this, "login", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "login", throwable);
            throw throwable;
        }
    }

    private void __login() {
        if (this.isLoggedIn()) {
            this.__getm_logger().error("Already logged in : " + this.__getm_user());
            return;
        }
        if (this.isLogginInProgress()) {
            this.__getm_logger().error("Already connecting ... ");
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    while (!JabberConnector.this.isLoggedIn() && JabberConnector.this.__getm_loggingIn()) {
                        try {
                            JabberConnector.this._login();
                            JabberConnector.this.__getm_connection().getRoster().setSubscriptionMode(JabberConnector.this.__getm_invitation());
                            JabberConnector.this.__getm_connection().getRoster().addRosterListener(JabberConnector.this);
                            JabberConnector.access$302(JabberConnector.this, true);
                            JabberConnector.this.__getm_logger().info("logged in on '" + JabberConnector.this.__getm_host() + "' on port " + JabberConnector.this.__getm_port() + " with username '" + JabberConnector.this.__getm_user() + "'");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (JabberConnector.this.__getm_connection() != null) {
                                JabberConnector.this.__getm_connection().disconnect();
                                JabberConnector.access$202(JabberConnector.this, null);
                            }
                            JabberConnector.this.__getm_logger().error("Can't login, error code: " + e.getMessage());
                            JabberConnector.this.waitBeforeRetry();
                        }
                    }
                }
                finally {
                    JabberConnector.access$002(JabberConnector.this, false);
                }
            }
        };
        this.__setm_loggingIn(true);
        this.__setm_connectionThread(new Thread(runnable));
        this.__getm_connectionThread().start();
    }

    public void logout() {
        if (!this.__Mlogout) {
            this.__logout();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "logout", new Object[0]);
            this.__logout();
            this.__IM.onExit((Object)this, "logout", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "logout", throwable);
            throw throwable;
        }
    }

    private void __logout() {
        while (this.__getm_connectionThread() != null && this.__getm_loggingIn()) {
            this.__setm_loggingIn(false);
            try {
                this.__getm_connectionThread().join(10000L);
            }
            catch (InterruptedException e) {
                this.__getm_logger().error("Tried to stop login thread, but got interrupted", (Throwable)e);
            }
        }
        this._logout();
    }

    public boolean isLoggedIn() {
        boolean bl;
        if (!this.__MisLoggedIn) {
            return this.__isLoggedIn();
        }
        try {
            this.__IM.onEntry((Object)this, "isLoggedIn", new Object[0]);
            bl = this.__isLoggedIn();
            this.__IM.onExit((Object)this, "isLoggedIn", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isLoggedIn", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isLoggedIn() {
        return this.__getm_loggedIn();
    }

    public boolean isLogginInProgress() {
        boolean bl;
        if (!this.__MisLogginInProgress) {
            return this.__isLogginInProgress();
        }
        try {
            this.__IM.onEntry((Object)this, "isLogginInProgress", new Object[0]);
            bl = this.__isLogginInProgress();
            this.__IM.onExit((Object)this, "isLogginInProgress", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isLogginInProgress", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isLogginInProgress() {
        return this.__getm_loggingIn();
    }

    @Override
    public synchronized void processMessage(Chat chat, Message message) {
        if (!this.__MprocessMessage$org_jivesoftware_smack_Chat$org_jivesoftware_smack_packet_Message) {
            this.__processMessage(chat, message);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "processMessage$org_jivesoftware_smack_Chat$org_jivesoftware_smack_packet_Message", new Object[]{chat, message});
            this.__processMessage(chat, message);
            this.__IM.onExit((Object)this, "processMessage$org_jivesoftware_smack_Chat$org_jivesoftware_smack_packet_Message", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "processMessage$org_jivesoftware_smack_Chat$org_jivesoftware_smack_packet_Message", throwable);
            throw throwable;
        }
    }

    private void __processMessage(Chat chat, Message message) {
        String body = message.getBody();
        if (body == null || message.getType() != Message.Type.chat) {
            return;
        }
        Collection<String> names = message.getPropertyNames();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (String k : names) {
            properties.put(k, message.getProperty(k));
        }
        String from = message.getFrom();
        this.__getm_logger().info(this + "-> got message '" + body + "' from " + from + " (" + message.getPacketID() + ")");
        DiscussionImpl disc = (DiscussionImpl)this.__getm_activeDiscussions().get(chat.getParticipant());
        if (disc == null) {
            DiscussionImpl newDiscussion = new DiscussionImpl(this, this.__getm_connection(), from, chat);
            this.__getm_activeDiscussions().put(from, newDiscussion);
            this.__getm_logger().info("Created new discussion for " + from);
        } else {
            disc.setChat(chat);
        }
        disc.dispatchMessage(body, properties);
    }

    @Override
    public void connectionClosed() {
        if (!this.__MconnectionClosed) {
            this.__connectionClosed();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "connectionClosed", new Object[0]);
            this.__connectionClosed();
            this.__IM.onExit((Object)this, "connectionClosed", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "connectionClosed", throwable);
            throw throwable;
        }
    }

    private void __connectionClosed() {
        this.__getm_logger().info("connectionClosed");
        this.logout();
        if (this.__getm_doReconnect()) {
            this.waitBeforeRetry();
            this.login();
        }
    }

    @Override
    public void connectionClosedOnError(Exception exception) {
        if (!this.__MconnectionClosedOnError$java_lang_Exception) {
            this.__connectionClosedOnError(exception);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "connectionClosedOnError$java_lang_Exception", new Object[]{exception});
            this.__connectionClosedOnError(exception);
            this.__IM.onExit((Object)this, "connectionClosedOnError$java_lang_Exception", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "connectionClosedOnError$java_lang_Exception", throwable);
            throw throwable;
        }
    }

    private void __connectionClosedOnError(Exception exception) {
        this.__getm_logger().error("connectionClosedOnError" + exception);
        this.logout();
        if (this.__getm_doReconnect()) {
            this.waitBeforeRetry();
            this.login();
        }
    }

    private void waitBeforeRetry() {
        if (!this.__MwaitBeforeRetry) {
            this.__waitBeforeRetry();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "waitBeforeRetry", new Object[0]);
            this.__waitBeforeRetry();
            this.__IM.onExit((Object)this, "waitBeforeRetry", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "waitBeforeRetry", throwable);
            throw throwable;
        }
    }

    private void __waitBeforeRetry() {
        this.__getm_logger().info("waitBeforeRetry 60000");
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void _logout() {
        if (!this.__M_logout) {
            this.___logout();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "_logout", new Object[0]);
            this.___logout();
            this.__IM.onExit((Object)this, "_logout", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "_logout", throwable);
            throw throwable;
        }
    }

    private void ___logout() {
        this.__getm_logger().info("logout");
        if (!this.isLoggedIn()) {
            this.__getm_logger().info("tried to logout but was already logged out");
            return;
        }
        Presence.Type type = Presence.Type.unsubscribed;
        Presence presence = new Presence(type);
        presence.setMode(Presence.Mode.away);
        if (this.__getm_connection().isConnected()) {
            this.__getm_connection().sendPacket(presence);
            this.__getm_connection().removeConnectionListener(this);
            this.__getm_connection().disconnect();
        }
        this.__getm_activeDiscussions().clear();
        this.__setm_connection(null);
        this.__setm_loggedIn(false);
    }

    protected synchronized void _login() throws XMPPException {
        if (!this.__M_login) {
            this.___login();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "_login", new Object[0]);
            this.___login();
            this.__IM.onExit((Object)this, "_login", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "_login", throwable);
            throw throwable;
        }
    }

    private void ___login() throws XMPPException {
        if (this.__getm_loggedIn()) {
            this.__getm_logger().error("Tried to login but was already logged in");
            return;
        }
        this.__getm_logger().info("Try to connect to " + this.__getm_host() + ":" + this.__getm_port() + " - " + this.__getm_serviceName() + " (" + this.__getm_user() + ")");
        ConnectionConfiguration config = new ConnectionConfiguration(this.__getm_host(), this.__getm_port(), this.__getm_serviceName());
        config.setSelfSignedCertificateEnabled(true);
        config.setSASLAuthenticationEnabled(true);
        this.__setm_connection(new XMPPConnection(config));
        this.__getm_connection().connect();
        this.__getm_connection().login(this.__getm_user(), this.__getm_password());
        this.__getm_connection().getChatManager().addChatListener(this);
        Presence presence = new Presence(Presence.Type.available);
        this.__getm_connection().sendPacket(presence);
        this.__getm_connection().addConnectionListener(this);
    }

    public void stop() {
        if (!this.__Mstop) {
            this.__stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __stop() {
        this.__getm_logger().info("Shutdown Jabber Connection");
        this.__setm_doReconnect(false);
        if (this.__getm_connection() != null) {
            this.logout();
        }
    }

    public void start() {
        if (!this.__Mstart) {
            this.__start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    @Validate
    private void __start() {
        this.__setm_doReconnect(true);
        this.login();
    }

    @Override
    public void reconnectingIn(int n) {
        if (!this.__MreconnectingIn$int) {
            this.__reconnectingIn(n);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reconnectingIn$int", new Object[]{new Integer(n)});
            this.__reconnectingIn(n);
            this.__IM.onExit((Object)this, "reconnectingIn$int", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reconnectingIn$int", throwable);
            throw throwable;
        }
    }

    private void __reconnectingIn(int arg0) {
        this.__getm_logger().info("Start Reconnecting");
    }

    @Override
    public void reconnectionFailed(Exception exception) {
        if (!this.__MreconnectionFailed$java_lang_Exception) {
            this.__reconnectionFailed(exception);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reconnectionFailed$java_lang_Exception", new Object[]{exception});
            this.__reconnectionFailed(exception);
            this.__IM.onExit((Object)this, "reconnectionFailed$java_lang_Exception", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reconnectionFailed$java_lang_Exception", throwable);
            throw throwable;
        }
    }

    private void __reconnectionFailed(Exception arg0) {
        this.__getm_logger().error("Reconnection failed", (Throwable)arg0);
    }

    @Override
    public void reconnectionSuccessful() {
        if (!this.__MreconnectionSuccessful) {
            this.__reconnectionSuccessful();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "reconnectionSuccessful", new Object[0]);
            this.__reconnectionSuccessful();
            this.__IM.onExit((Object)this, "reconnectionSuccessful", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "reconnectionSuccessful", throwable);
            throw throwable;
        }
    }

    private void __reconnectionSuccessful() {
        this.__getm_logger().info("Reconnected");
    }

    @Override
    public synchronized void chatCreated(Chat chat, boolean bl) {
        if (!this.__MchatCreated$org_jivesoftware_smack_Chat$boolean) {
            this.__chatCreated(chat, bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "chatCreated$org_jivesoftware_smack_Chat$boolean", new Object[]{chat, new Boolean(bl)});
            this.__chatCreated(chat, bl);
            this.__IM.onExit((Object)this, "chatCreated$org_jivesoftware_smack_Chat$boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "chatCreated$org_jivesoftware_smack_Chat$boolean", throwable);
            throw throwable;
        }
    }

    private void __chatCreated(Chat chat, boolean arg1) {
        this.__getm_logger().info(this + " - chat created: " + chat.getParticipant());
        if (!this.__getm_activeDiscussions().containsKey(chat.getParticipant())) {
            DiscussionImpl newDiscussion = new DiscussionImpl(this, this.__getm_connection(), chat.getParticipant(), chat);
            this.__getm_activeDiscussions().put(chat.getParticipant(), newDiscussion);
            this.__getm_logger().info(this + " - Notify connection listener " + this.__getm_discussionListeners().size());
            for (DiscussionListener listener : this.__getm_discussionListeners()) {
                ArrayList<String> participants = new ArrayList<String>();
                participants.add(chat.getParticipant());
                listener.onNewDiscussion(newDiscussion, participants);
            }
        }
        if (chat.getListeners() != null && !chat.getListeners().contains(this)) {
            chat.addMessageListener(this);
        }
    }

    @Override
    public synchronized void addContactListener(ContactListener contactListener) {
        if (!this.__MaddContactListener$org_ow2_chameleon_chat_ContactListener) {
            this.__addContactListener(contactListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addContactListener$org_ow2_chameleon_chat_ContactListener", new Object[]{contactListener});
            this.__addContactListener(contactListener);
            this.__IM.onExit((Object)this, "addContactListener$org_ow2_chameleon_chat_ContactListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addContactListener$org_ow2_chameleon_chat_ContactListener", throwable);
            throw throwable;
        }
    }

    private void __addContactListener(ContactListener listener) {
        if (this.__getm_connection() == null) {
            throw new IllegalStateException("Not connected");
        }
        this.__getm_contactListeners().add(listener);
    }

    @Override
    public List<String> getContactList() {
        List<String> list;
        if (!this.__MgetContactList) {
            return this.__getContactList();
        }
        try {
            this.__IM.onEntry((Object)this, "getContactList", new Object[0]);
            list = this.__getContactList();
            this.__IM.onExit((Object)this, "getContactList", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getContactList", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getContactList() {
        if (this.__getm_connection() == null) {
            throw new IllegalStateException("Not connected");
        }
        ArrayList<String> contacts = new ArrayList<String>();
        Collection<RosterEntry> entries = this.__getm_connection().getRoster().getEntries();
        if (entries != null) {
            for (RosterEntry contact : entries) {
                contacts.add(contact.getUser());
            }
        }
        return contacts;
    }

    @Override
    public Discussion getDiscussion(String string) {
        Discussion discussion;
        if (!this.__MgetDiscussion$java_lang_String) {
            return this.__getDiscussion(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getDiscussion$java_lang_String", new Object[]{string});
            discussion = this.__getDiscussion(string);
            this.__IM.onExit((Object)this, "getDiscussion$java_lang_String", (Object)discussion);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDiscussion$java_lang_String", throwable);
            throw throwable;
        }
        return discussion;
    }

    private Discussion __getDiscussion(String contact) {
        if (this.__getm_connection() == null) {
            throw new IllegalStateException("Not connected");
        }
        if (this.__getm_activeDiscussions().containsKey(contact)) {
            return (Discussion)this.__getm_activeDiscussions().get(contact);
        }
        DiscussionImpl newDiscussion = new DiscussionImpl(this, this.__getm_connection(), contact);
        this.__getm_activeDiscussions().put(contact, newDiscussion);
        this.__getm_logger().info("Create conversation for " + contact);
        return newDiscussion;
    }

    @Override
    public List<String> getOnlineContactList() {
        List<String> list;
        if (!this.__MgetOnlineContactList) {
            return this.__getOnlineContactList();
        }
        try {
            this.__IM.onEntry((Object)this, "getOnlineContactList", new Object[0]);
            list = this.__getOnlineContactList();
            this.__IM.onExit((Object)this, "getOnlineContactList", list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getOnlineContactList", throwable);
            throw throwable;
        }
        return list;
    }

    private List<String> __getOnlineContactList() {
        if (this.__getm_connection() == null) {
            throw new IllegalStateException("Not connected");
        }
        List<String> list = this.getContactList();
        ArrayList<String> online = new ArrayList<String>();
        for (String user : list) {
            if (this.__getm_connection().getRoster().getPresence(user).getType() != Presence.Type.available) continue;
            online.add(user);
        }
        return online;
    }

    @Override
    public synchronized void removeContactListener(ContactListener contactListener) {
        if (!this.__MremoveContactListener$org_ow2_chameleon_chat_ContactListener) {
            this.__removeContactListener(contactListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeContactListener$org_ow2_chameleon_chat_ContactListener", new Object[]{contactListener});
            this.__removeContactListener(contactListener);
            this.__IM.onExit((Object)this, "removeContactListener$org_ow2_chameleon_chat_ContactListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeContactListener$org_ow2_chameleon_chat_ContactListener", throwable);
            throw throwable;
        }
    }

    private void __removeContactListener(ContactListener listener) {
        if (this.__getm_connection() == null) {
            throw new IllegalStateException("Not connected");
        }
        this.__getm_contactListeners().remove(listener);
    }

    @Override
    public void setPresence(ChatService.Presence presence, String string) {
        if (!this.__MsetPresence$org_ow2_chameleon_chat_ChatService$Presence$java_lang_String) {
            this.__setPresence(presence, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setPresence$org_ow2_chameleon_chat_ChatService$Presence$java_lang_String", new Object[]{presence, string});
            this.__setPresence(presence, string);
            this.__IM.onExit((Object)this, "setPresence$org_ow2_chameleon_chat_ChatService$Presence$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setPresence$org_ow2_chameleon_chat_ChatService$Presence$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setPresence(ChatService.Presence newPresence, String status) {
        if (this.__getm_connection() == null) {
            throw new IllegalStateException("Not connected");
        }
        Presence.Mode mode = Presence.Mode.available;
        Presence.Type type = Presence.Type.available;
        switch (newPresence) {
            case AWAY: {
                mode = Presence.Mode.away;
                type = Presence.Type.available;
                break;
            }
            case OFFLINE: {
                mode = Presence.Mode.xa;
                type = Presence.Type.unavailable;
            }
            case ONLINE: {
                mode = Presence.Mode.available;
                type = Presence.Type.available;
            }
        }
        Presence presence = new Presence(type, status, 0, mode);
        this.__getm_connection().sendPacket(presence);
    }

    @Override
    public void entriesAdded(Collection<String> collection) {
        if (!this.__MentriesAdded$java_util_Collection) {
            this.__entriesAdded(collection);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "entriesAdded$java_util_Collection", new Object[]{collection});
            this.__entriesAdded(collection);
            this.__IM.onExit((Object)this, "entriesAdded$java_util_Collection", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "entriesAdded$java_util_Collection", throwable);
            throw throwable;
        }
    }

    private void __entriesAdded(Collection<String> entries) {
    }

    @Override
    public void entriesDeleted(Collection<String> collection) {
        if (!this.__MentriesDeleted$java_util_Collection) {
            this.__entriesDeleted(collection);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "entriesDeleted$java_util_Collection", new Object[]{collection});
            this.__entriesDeleted(collection);
            this.__IM.onExit((Object)this, "entriesDeleted$java_util_Collection", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "entriesDeleted$java_util_Collection", throwable);
            throw throwable;
        }
    }

    private void __entriesDeleted(Collection<String> arg0) {
    }

    @Override
    public void entriesUpdated(Collection<String> collection) {
        if (!this.__MentriesUpdated$java_util_Collection) {
            this.__entriesUpdated(collection);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "entriesUpdated$java_util_Collection", new Object[]{collection});
            this.__entriesUpdated(collection);
            this.__IM.onExit((Object)this, "entriesUpdated$java_util_Collection", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "entriesUpdated$java_util_Collection", throwable);
            throw throwable;
        }
    }

    private void __entriesUpdated(Collection<String> arg0) {
    }

    @Override
    public void presenceChanged(Presence presence) {
        if (!this.__MpresenceChanged$org_jivesoftware_smack_packet_Presence) {
            this.__presenceChanged(presence);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "presenceChanged$org_jivesoftware_smack_packet_Presence", new Object[]{presence});
            this.__presenceChanged(presence);
            this.__IM.onExit((Object)this, "presenceChanged$org_jivesoftware_smack_packet_Presence", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "presenceChanged$org_jivesoftware_smack_packet_Presence", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __presenceChanged(Presence presence) {
        ArrayList listeners = null;
        JabberConnector jabberConnector = this;
        synchronized (jabberConnector) {
            listeners = new ArrayList(this.__getm_contactListeners());
        }
        String user = presence.getFrom();
        Presence bestPresence = this.__getm_connection().getRoster().getPresence(user);
        Presence.Mode mode = bestPresence.getMode();
        ChatService.Presence pres = ChatService.Presence.OFFLINE;
        switch (bestPresence.getType()) {
            case available: {
                pres = ChatService.Presence.ONLINE;
                if (mode == null) break;
                switch (mode) {
                    case available: {
                        pres = ChatService.Presence.ONLINE;
                        break;
                    }
                    case away: {
                        pres = ChatService.Presence.AWAY;
                        break;
                    }
                    case chat: {
                        pres = ChatService.Presence.ONLINE;
                        break;
                    }
                    case dnd: {
                        pres = ChatService.Presence.AWAY;
                        break;
                    }
                    case xa: {
                        pres = ChatService.Presence.AWAY;
                    }
                }
                break;
            }
            case unavailable: {
                pres = ChatService.Presence.OFFLINE;
                break;
            }
        }
        for (ContactListener listener : listeners) {
            listener.onContactStatusChanged(user, pres, bestPresence.getStatus());
        }
    }

    @Override
    public void addDiscussionListener(DiscussionListener discussionListener) {
        if (!this.__MaddDiscussionListener$org_ow2_chameleon_chat_DiscussionListener) {
            this.__addDiscussionListener(discussionListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "addDiscussionListener$org_ow2_chameleon_chat_DiscussionListener", new Object[]{discussionListener});
            this.__addDiscussionListener(discussionListener);
            this.__IM.onExit((Object)this, "addDiscussionListener$org_ow2_chameleon_chat_DiscussionListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "addDiscussionListener$org_ow2_chameleon_chat_DiscussionListener", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void __addDiscussionListener(DiscussionListener listener) {
        ArrayList<Object> list = new ArrayList();
        JabberConnector jabberConnector = this;
        synchronized (jabberConnector) {
            this.__getm_logger().info(this + " - New connection listener added");
            this.__getm_discussionListeners().add(listener);
            list = new ArrayList(this.__getm_activeDiscussions().values());
        }
        for (Discussion discussion : list) {
            listener.onNewDiscussion(discussion, discussion.getParticipants());
        }
    }

    @Override
    public synchronized void removeDiscussionListener(DiscussionListener discussionListener) {
        if (!this.__MremoveDiscussionListener$org_ow2_chameleon_chat_DiscussionListener) {
            this.__removeDiscussionListener(discussionListener);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "removeDiscussionListener$org_ow2_chameleon_chat_DiscussionListener", new Object[]{discussionListener});
            this.__removeDiscussionListener(discussionListener);
            this.__IM.onExit((Object)this, "removeDiscussionListener$org_ow2_chameleon_chat_DiscussionListener", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "removeDiscussionListener$org_ow2_chameleon_chat_DiscussionListener", throwable);
            throw throwable;
        }
    }

    private void __removeDiscussionListener(DiscussionListener listener) {
        this.__getm_discussionListeners().remove(listener);
    }

    public synchronized void closeDiscussion(String string, DiscussionImpl discussionImpl) {
        if (!this.__McloseDiscussion$java_lang_String$org_ow2_chameleon_messaging_jabber_impl_DiscussionImpl) {
            this.__closeDiscussion(string, discussionImpl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "closeDiscussion$java_lang_String$org_ow2_chameleon_messaging_jabber_impl_DiscussionImpl", new Object[]{string, discussionImpl});
            this.__closeDiscussion(string, discussionImpl);
            this.__IM.onExit((Object)this, "closeDiscussion$java_lang_String$org_ow2_chameleon_messaging_jabber_impl_DiscussionImpl", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "closeDiscussion$java_lang_String$org_ow2_chameleon_messaging_jabber_impl_DiscussionImpl", throwable);
            throw throwable;
        }
    }

    private void __closeDiscussion(String contact, DiscussionImpl conv) {
        this.__getm_activeDiscussions().remove(contact);
    }

    public void setService(String string) {
        if (!this.__MsetService$java_lang_String) {
            this.__setService(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setService$java_lang_String", new Object[]{string});
            this.__setService(string);
            this.__IM.onExit((Object)this, "setService$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setService$java_lang_String", throwable);
            throw throwable;
        }
    }

    @Property(name="jabber.service", mandatory=true)
    private void __setService(String service) {
        this.__setm_serviceName(service);
    }

    public void setUSer(String string) {
        if (!this.__MsetUSer$java_lang_String) {
            this.__setUSer(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setUSer$java_lang_String", new Object[]{string});
            this.__setUSer(string);
            this.__IM.onExit((Object)this, "setUSer$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setUSer$java_lang_String", throwable);
            throw throwable;
        }
    }

    @Property(name="jabber.user", mandatory=true)
    private void __setUSer(String user) {
        this.__setm_user(user);
    }

    static /* synthetic */ boolean access$302(JabberConnector x0, boolean x1) {
        boolean bl = x1;
        x0.__setm_loggedIn(bl);
        return bl;
    }

    static /* synthetic */ XMPPConnection access$202(JabberConnector x0, XMPPConnection x1) {
        XMPPConnection xMPPConnection = x1;
        x0.__setm_connection(xMPPConnection);
        return xMPPConnection;
    }

    static /* synthetic */ boolean access$002(JabberConnector x0, boolean x1) {
        boolean bl = x1;
        x0.__setm_loggingIn(bl);
        return bl;
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("m_discussionListeners")) {
                this.__Fm_discussionListeners = true;
            }
            if (set.contains("m_user")) {
                this.__Fm_user = true;
            }
            if (set.contains("m_serviceName")) {
                this.__Fm_serviceName = true;
            }
            if (set.contains("m_host")) {
                this.__Fm_host = true;
            }
            if (set.contains("m_doReconnect")) {
                this.__Fm_doReconnect = true;
            }
            if (set.contains("m_loggedIn")) {
                this.__Fm_loggedIn = true;
            }
            if (set.contains("m_loggingIn")) {
                this.__Fm_loggingIn = true;
            }
            if (set.contains("m_invitationPolicy")) {
                this.__Fm_invitationPolicy = true;
            }
            if (set.contains("m_logger")) {
                this.__Fm_logger = true;
            }
            if (set.contains("m_activeDiscussions")) {
                this.__Fm_activeDiscussions = true;
            }
            if (set.contains("m_contactListeners")) {
                this.__Fm_contactListeners = true;
            }
            if (set.contains("m_password")) {
                this.__Fm_password = true;
            }
            if (set.contains("m_port")) {
                this.__Fm_port = true;
            }
            if (set.contains("m_connectionThread")) {
                this.__Fm_connectionThread = true;
            }
            if (set.contains("m_invitation")) {
                this.__Fm_invitation = true;
            }
            if (set.contains("m_connection")) {
                this.__Fm_connection = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("login")) {
                this.__Mlogin = true;
            }
            if (set.contains("logout")) {
                this.__Mlogout = true;
            }
            if (set.contains("isLoggedIn")) {
                this.__MisLoggedIn = true;
            }
            if (set.contains("isLogginInProgress")) {
                this.__MisLogginInProgress = true;
            }
            if (set.contains("processMessage$org_jivesoftware_smack_Chat$org_jivesoftware_smack_packet_Message")) {
                this.__MprocessMessage$org_jivesoftware_smack_Chat$org_jivesoftware_smack_packet_Message = true;
            }
            if (set.contains("connectionClosed")) {
                this.__MconnectionClosed = true;
            }
            if (set.contains("connectionClosedOnError$java_lang_Exception")) {
                this.__MconnectionClosedOnError$java_lang_Exception = true;
            }
            if (set.contains("waitBeforeRetry")) {
                this.__MwaitBeforeRetry = true;
            }
            if (set.contains("_logout")) {
                this.__M_logout = true;
            }
            if (set.contains("_login")) {
                this.__M_login = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("reconnectingIn$int")) {
                this.__MreconnectingIn$int = true;
            }
            if (set.contains("reconnectionFailed$java_lang_Exception")) {
                this.__MreconnectionFailed$java_lang_Exception = true;
            }
            if (set.contains("reconnectionSuccessful")) {
                this.__MreconnectionSuccessful = true;
            }
            if (set.contains("chatCreated$org_jivesoftware_smack_Chat$boolean")) {
                this.__MchatCreated$org_jivesoftware_smack_Chat$boolean = true;
            }
            if (set.contains("addContactListener$org_ow2_chameleon_chat_ContactListener")) {
                this.__MaddContactListener$org_ow2_chameleon_chat_ContactListener = true;
            }
            if (set.contains("getContactList")) {
                this.__MgetContactList = true;
            }
            if (set.contains("getDiscussion$java_lang_String")) {
                this.__MgetDiscussion$java_lang_String = true;
            }
            if (set.contains("getOnlineContactList")) {
                this.__MgetOnlineContactList = true;
            }
            if (set.contains("removeContactListener$org_ow2_chameleon_chat_ContactListener")) {
                this.__MremoveContactListener$org_ow2_chameleon_chat_ContactListener = true;
            }
            if (set.contains("setPresence$org_ow2_chameleon_chat_ChatService$Presence$java_lang_String")) {
                this.__MsetPresence$org_ow2_chameleon_chat_ChatService$Presence$java_lang_String = true;
            }
            if (set.contains("entriesAdded$java_util_Collection")) {
                this.__MentriesAdded$java_util_Collection = true;
            }
            if (set.contains("entriesDeleted$java_util_Collection")) {
                this.__MentriesDeleted$java_util_Collection = true;
            }
            if (set.contains("entriesUpdated$java_util_Collection")) {
                this.__MentriesUpdated$java_util_Collection = true;
            }
            if (set.contains("presenceChanged$org_jivesoftware_smack_packet_Presence")) {
                this.__MpresenceChanged$org_jivesoftware_smack_packet_Presence = true;
            }
            if (set.contains("addDiscussionListener$org_ow2_chameleon_chat_DiscussionListener")) {
                this.__MaddDiscussionListener$org_ow2_chameleon_chat_DiscussionListener = true;
            }
            if (set.contains("removeDiscussionListener$org_ow2_chameleon_chat_DiscussionListener")) {
                this.__MremoveDiscussionListener$org_ow2_chameleon_chat_DiscussionListener = true;
            }
            if (set.contains("closeDiscussion$java_lang_String$org_ow2_chameleon_messaging_jabber_impl_DiscussionImpl")) {
                this.__McloseDiscussion$java_lang_String$org_ow2_chameleon_messaging_jabber_impl_DiscussionImpl = true;
            }
            if (set.contains("setService$java_lang_String")) {
                this.__MsetService$java_lang_String = true;
            }
            if (set.contains("setUSer$java_lang_String")) {
                this.__MsetUSer$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

