/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.messaging.jabber.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.ow2.chameleon.chat.Discussion;
import org.ow2.chameleon.chat.MessageReceiver;
import org.ow2.chameleon.messaging.jabber.impl.JabberConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscussionImpl
implements Discussion {
    private JabberConnector m_connector;
    private XMPPConnection m_connection;
    private String m_contact;
    private Chat m_chat;
    private MessageReceiver m_receiver;

    public DiscussionImpl(JabberConnector jabberConnector, XMPPConnection connection, String contact) {
        this.m_connector = jabberConnector;
        this.m_connection = connection;
        this.m_contact = contact;
        this.m_chat = this.m_connection.getChatManager().createChat(this.m_contact, this.m_connector);
    }

    public DiscussionImpl(JabberConnector jabberConnector, XMPPConnection connection, String contact, Chat chat) {
        this.m_connector = jabberConnector;
        this.m_connection = connection;
        this.m_contact = contact;
        this.m_chat = chat;
    }

    @Override
    public synchronized void close() {
        this.m_receiver = null;
        this.m_connector.closeDiscussion(this.m_contact, this);
    }

    @Override
    public synchronized List<String> getParticipants() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.m_chat.getParticipant());
        return list;
    }

    @Override
    public synchronized void registerMessageReceiver(MessageReceiver receiver) {
        this.m_receiver = receiver;
    }

    @Override
    public synchronized void sendMessage(String message) throws Exception {
        if (this.m_chat != null) {
            this.m_chat.sendMessage(message);
        }
    }

    @Override
    public synchronized void sendMessage(String body, Map<String, ?> props) throws Exception {
        Message message = new Message();
        message.setBody(body);
        if (props != null) {
            for (String k : props.keySet()) {
                message.setProperty(k, props.get(k));
            }
        }
        if (this.m_chat != null) {
            this.m_chat.sendMessage(message);
        }
    }

    @Override
    public synchronized void unregisterMessageReceiver(MessageReceiver receiver) {
        this.m_receiver = null;
    }

    protected synchronized void dispatchMessage(String body, Map<String, Object> properties) {
        if (this.m_receiver != null) {
            this.m_receiver.onReceivedMessage(this, this.m_contact, body, properties);
        }
    }

    public synchronized void setChat(Chat chat) {
        this.m_chat = chat;
    }
}

