/*
 * Copyright 2009 OW2 Chameleon
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.ow2.chameleon.database.connection;

import java.sql.Connection;
import java.sql.SQLException;

/**
 * Database Connection Factory service. This service specification provides
 * access to a database. Providers exposing this service publishes:
 * <ul>
 * <li>'org.jdbc.user' : the user of the database</li>
 * <li>'org.jdbc.url' : the JDBC url of the database (mandatory)</li>
 * </ul>
 * The services is only exposed if the database is available and accessible.
 * @author <a href="mailto:chameleon-dev@ow2.org">Chameleon Project Team</a>
 * @version 1.0.0
 */
public interface ConnectionFactory {

    /**
     * Key for the DataSource configuration.
     */
    public static final String JDBC_URL = "org.jdbc.url";

    /**
     * Key for the DataSource configuration.
     */
    public static final String JDBC_USER = "org.jdbc.user";

    /**
     * This is a composable service. Implementation may want to use a Datasource
     * factory.
     */
    public static final String specification = "specification { "
            + "requires { "
            + "$specification=\"org.osgi.service.jdbc.DataSourceFactory\" "
            + "$optional=\"true\" " + "} }";

    /**
     * Creates a new SQL Connection on the database. The connection MUST be
     * closed when useless. The creation policy depends on the implementation
     * @return a new Connection on the database
     * @throws SQLException when an issue occurs during the Connection
     *         initialization.
     * @see javax.sql.DataSource
     */
    public Connection createConnection() throws SQLException;

}
