/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.derby;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.osgi.service.jdbc.DataSourceFactory;
import org.ow2.chameleon.database.connection.ConnectionFactory;

public class DerbyConnectionFactory
implements ConnectionFactory {
    private String url;
    private String user;
    private String password;
    private DataSource source;

    public synchronized void bindFactory(DataSourceFactory factory) {
        Properties props = new Properties();
        props.put("org.jdbc.url", this.url);
        if (this.user != null) {
            props.put("org.jdbc.user", this.user);
        }
        if (this.password != null) {
            props.put("org.jdbc.password", this.password);
        }
        this.source = factory.createDataSource(props);
    }

    public synchronized void unbindFactory() {
        this.source = null;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String pwd) {
        this.password = pwd;
    }

    public Connection createConnection() throws SQLException {
        return this.source.getConnection();
    }
}

