/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.bridge.impl;

import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHBridgeResourcesCache;
import com.philips.lighting.model.PHGroup;
import com.philips.lighting.model.PHLight;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;

public class PHBridgeResourcesCacheImpl
implements PHBridgeResourcesCache {
    private Hashtable<String, PHLight> lights;
    private Hashtable<String, PHGroup> groups;
    private PHBridgeConfiguration bridgeConfig;
    private Hashtable<String, PHSchedule> schedules;
    private Hashtable<String, PHScene> scenes;

    public void setBridgeConfiguration(PHBridgeConfiguration phBridgeConfig) {
        this.bridgeConfig = phBridgeConfig;
    }

    public void setLights(Hashtable<String, PHLight> lights) {
        this.lights = lights;
    }

    public void setGroups(Hashtable<String, PHGroup> groups) {
        this.groups = groups;
    }

    public void setSchedules(Hashtable<String, PHSchedule> schedules) {
        this.schedules = schedules;
    }

    public void setScenes(Hashtable<String, PHScene> scenes) {
        this.scenes = scenes;
    }

    @Override
    public Hashtable<String, PHLight> getLights() {
        return this.lights;
    }

    @Override
    public Hashtable<String, PHGroup> getGroups() {
        return this.groups;
    }

    @Override
    public PHBridgeConfiguration getBridgeConfiguration() {
        return this.bridgeConfig;
    }

    @Override
    public Hashtable<String, PHSchedule> getSchedules() {
        return this.schedules;
    }

    @Override
    public Hashtable<String, PHScene> getScenes() {
        return this.scenes;
    }

    @Override
    public List<PHLight> getAllLights() {
        ArrayList<PHLight> lightsList = new ArrayList<PHLight>();
        Collection<PHLight> values = this.lights.values();
        for (PHLight light : values) {
            lightsList.add(light);
        }
        return lightsList;
    }

    @Override
    public List<PHGroup> getAllGroups() {
        ArrayList<PHGroup> groupsList = new ArrayList<PHGroup>();
        Collection<PHGroup> values = this.groups.values();
        for (PHGroup group : values) {
            groupsList.add(group);
        }
        return groupsList;
    }

    @Override
    public List<PHScene> getAllScenes() {
        if (this.scenes == null) {
            return null;
        }
        Collection<PHScene> values = this.scenes.values();
        ArrayList<PHScene> list = new ArrayList<PHScene>();
        for (PHScene scene : values) {
            list.add(scene);
        }
        return list;
    }

    @Override
    public List<PHSchedule> getAllSchedules(boolean areReccurring) {
        Collection<PHSchedule> values = this.schedules.values();
        ArrayList<PHSchedule> scheduleList = new ArrayList<PHSchedule>();
        for (PHSchedule schedule : values) {
            if (areReccurring && schedule.getRecurringDays() != 0 && schedule.getDate() != null) {
                scheduleList.add(schedule);
                continue;
            }
            if (areReccurring || schedule.getRecurringDays() != 0 || schedule.getDate() == null) continue;
            scheduleList.add(schedule);
        }
        return scheduleList;
    }

    @Override
    public List<PHSchedule> getAllTimers(boolean areReccurring) {
        Collection<PHSchedule> values = this.schedules.values();
        ArrayList<PHSchedule> timersList = new ArrayList<PHSchedule>();
        for (PHSchedule timer : values) {
            if (areReccurring && timer.getTimer() != 0 && timer.getRecurringTimerInterval() != 0) {
                timersList.add(timer);
                continue;
            }
            if (areReccurring || timer.getTimer() == 0 || timer.getRecurringTimerInterval() != 0) continue;
            timersList.add(timer);
        }
        return timersList;
    }
}

