/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip;

import com.philips.lighting.hue.sdk.clip.PHCLIPBuilder;
import com.philips.lighting.hue.sdk.clip.PHCLIPBuilder1_0;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PHCLIPBuilder1_1
extends PHCLIPBuilder1_0
implements PHCLIPBuilder {
    public static PHCLIPBuilder1_1 getInstance(int key) {
        if (key == 4626 || key == 13364) {
            return new PHCLIPBuilder1_1();
        }
        return null;
    }

    @Override
    public String createUpdateBridge(PHBridgeConfiguration bridgeConfig) throws JSONException {
        String jsonString = super.createUpdateBridge(bridgeConfig);
        JSONObject toSend = new JSONObject(jsonString);
        if (bridgeConfig.getTimeZone() != null && bridgeConfig.getTimeZone().length() > 0) {
            toSend.putOpt("timezone", bridgeConfig.getTimeZone());
        }
        if (bridgeConfig.getLocalTime() != null && bridgeConfig.getLocalTime().length() > 0) {
            toSend.putOpt("localtime", bridgeConfig.getLocalTime());
        }
        return toSend.toString();
    }

    @Override
    public String createSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone) throws JSONException {
        JSONObject cmd = new JSONObject();
        if (cmdAddress != null) {
            cmd.putOpt("address", cmdAddress);
        }
        if (method != null) {
            cmd.putOpt("method", method);
        }
        if (schedule.getLightIdentifier() != null || schedule.getGroupIdentifier() != null && schedule.getSceneIdentifier() == null) {
            if (schedule.getLightState() != null) {
                cmd.putOpt("body", this.lightStateForIdPacket(schedule.getLightState()));
            }
        } else if (schedule.getGroupIdentifier() != null && schedule.getSceneIdentifier() != null) {
            JSONObject sceneIdJson = new JSONObject();
            sceneIdJson.putOpt("scene", schedule.getSceneIdentifier());
            cmd.putOpt("body", sceneIdJson);
        }
        JSONObject toSend = new JSONObject();
        if (schedule.getName() != null) {
            toSend.putOpt("name", schedule.getName());
        }
        if (schedule.getDescription() != null && schedule.getDescription().length() != 0) {
            toSend.putOpt("description", schedule.getDescription());
        }
        if (cmd != null) {
            toSend.putOpt("command", cmd);
        }
        Date date = schedule.getDate();
        String timeTarget = "time";
        if (schedule.getLocalTime() != null && schedule.getLocalTime().booleanValue()) {
            timeTarget = "localtime";
        } else {
            timeZone = "UTC";
        }
        String randomTimeString = "";
        if (schedule.getRandomTime() != 0) {
            int randomHours = schedule.getRandomTime() / 3600;
            int randomMinutes = schedule.getRandomTime() % 3600 / 60;
            int randomSeconds = schedule.getRandomTime() % 3600 % 60;
            randomTimeString = String.format("A%02d:%02d:%02d", randomHours, randomMinutes, randomSeconds);
        }
        if (date != null) {
            if (schedule.getRecurringDays() != 0) {
                SimpleDateFormat dateFormate = new SimpleDateFormat("HH:mm:ss", new Locale("nl_NL"));
                dateFormate.setTimeZone(TimeZone.getTimeZone(timeZone));
                String timerTime = dateFormate.format(date);
                StringBuffer sb = new StringBuffer();
                String time = sb.append('W').append(schedule.getRecurringDays()).append("/T").append(timerTime).append(randomTimeString).toString();
                toSend.putOpt(timeTarget, time);
            } else {
                SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", new Locale("nl_NL"));
                dateFormate.setTimeZone(TimeZone.getTimeZone(timeZone));
                String timerTime = dateFormate.format(date);
                String time = String.format("%s%s", timerTime, randomTimeString);
                toSend.putOpt(timeTarget, time);
            }
        } else if (schedule.getTimer() != 0) {
            int ti = schedule.getTimer();
            int timerHours = ti / 3600;
            int timerMinutes = ti / 60 % 60;
            int timerSeconds = ti % 60;
            String timerTimeString = String.format("%02d:%02d:%02d", timerHours, timerMinutes, timerSeconds);
            if (schedule.getRecurringTimerInterval() == -1) {
                String time = String.format("R/PT%s%s", timerTimeString, randomTimeString);
                toSend.putOpt(timeTarget, time);
            } else if (schedule.getRecurringTimerInterval() > 0) {
                String time = String.format("R%02d/PT%s%s", schedule.getRecurringTimerInterval(), timerTimeString, randomTimeString);
                toSend.putOpt(timeTarget, time);
            } else {
                String time = String.format("PT%s%s", timerTimeString, randomTimeString);
                toSend.putOpt(timeTarget, time);
            }
        }
        String stringData = toSend.toString();
        stringData = stringData.replace("\\/", "/");
        return stringData;
    }

    @Override
    public String createSchedulePacket(PHSchedule schedule, String cmdAddress, String method) throws JSONException {
        return this.createSchedulePacket(schedule, cmdAddress, method, "UTC");
    }

    @Override
    public String updateSchedulePacket(PHSchedule schedule, String cmdAddress, String method, String timeZone) throws JSONException {
        JSONObject cmd = new JSONObject();
        if (cmdAddress != null) {
            cmd.putOpt("address", cmdAddress);
        }
        if (method != null) {
            cmd.putOpt("method", method);
        }
        if (schedule.getLightState() != null) {
            cmd.putOpt("body", this.lightStateForIdPacket(schedule.getLightState()));
        }
        JSONObject toSend = new JSONObject();
        if (schedule.getName() != null) {
            toSend.putOpt("name", schedule.getName());
        }
        if (schedule.getDescription() != null && schedule.getDescription().length() != 0) {
            toSend.putOpt("description", schedule.getDescription());
        }
        if (cmd != null) {
            toSend.putOpt("command", cmd);
        }
        Date date = schedule.getDate();
        String timeTarget = "time";
        if (schedule.getLocalTime() != null && schedule.getLocalTime().booleanValue()) {
            timeTarget = "localtime";
        } else {
            timeZone = "UTC";
        }
        String randomTimeString = "";
        if (schedule.getRandomTime() != 0) {
            int randomHours = schedule.getRandomTime() / 3600;
            int randomMinutes = schedule.getRandomTime() % 3600 / 60;
            int randomSeconds = schedule.getRandomTime() % 3600 % 60;
            randomTimeString = String.format("A%02d:%02d:%02d", randomHours, randomMinutes, randomSeconds);
        }
        if (date != null) {
            if (schedule.getRecurringDays() != 0) {
                SimpleDateFormat dateFormate = new SimpleDateFormat("HH:mm:ss", new Locale("nl_NL"));
                dateFormate.setTimeZone(TimeZone.getTimeZone(timeZone));
                String timerTime = dateFormate.format(date);
                String time = String.format("W%03d/T%s%s", schedule.getRecurringDays(), timerTime, randomTimeString);
                toSend.putOpt(timeTarget, time);
            } else {
                SimpleDateFormat dateFormate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", new Locale("nl_NL"));
                dateFormate.setTimeZone(TimeZone.getTimeZone(timeZone));
                String timerTime = dateFormate.format(date);
                String time = String.format("%s%s", timerTime, randomTimeString);
                toSend.putOpt(timeTarget, time);
            }
        } else if (schedule.getTimer() != 0) {
            int ti = schedule.getTimer();
            int timerHours = ti / 3600;
            int timerMinutes = ti / 60 % 60;
            int timerSeconds = ti % 60;
            String timerTimeString = String.format("%02d:%02d:%02d", timerHours, timerMinutes, timerSeconds);
            if (schedule.getRecurringTimerInterval() > 0) {
                String time = String.format("R%02d/PT%s%s", schedule.getRecurringTimerInterval(), timerTimeString, randomTimeString);
                toSend.putOpt(timeTarget, time);
            } else {
                String time = String.format("PT%s%s", timerTimeString, randomTimeString);
                toSend.putOpt(timeTarget, time);
            }
        }
        String stringData = toSend.toString();
        stringData = stringData.replace("\\/", "/");
        return stringData;
    }

    @Override
    public String updateSchedulePacket(PHSchedule schedule, String cmdAddress, String method) throws JSONException {
        return this.updateSchedulePacket(schedule, cmdAddress, method, "UTC");
    }

    public JSONObject createSceneJSONPacket(String name, String[] lightIdentifiers) throws JSONException {
        JSONObject toSend = new JSONObject();
        JSONArray array = new JSONArray();
        int i = 0;
        while (i < lightIdentifiers.length) {
            array.put(i, lightIdentifiers[i]);
            ++i;
        }
        toSend.putOpt("name", name);
        toSend.putOpt("lights", array);
        return toSend;
    }

    @Override
    public String createScenePacket(String name, String[] lightIdentifiers) throws JSONException {
        JSONObject toSend = this.createSceneJSONPacket(name, lightIdentifiers);
        return toSend.toString();
    }

    public String createScenePacket1_1_1(PHScene scene) throws JSONException {
        JSONObject toSend = this.createSceneJSONPacket(scene.getName(), scene.getLightIdentifiers());
        if (scene.getTransitionTime() != 0) {
            toSend.put("transitiontime", scene.getTransitionTime());
        }
        return toSend.toString();
    }

    @Override
    public String createActivateScenePacket(String sceneId) throws JSONException {
        JSONObject toSend = new JSONObject();
        toSend.putOpt("scene", sceneId);
        return toSend.toString();
    }

    @Override
    public String createFindLightSerialsPacket(List<String> serials) throws JSONException {
        JSONObject toSend = new JSONObject();
        JSONArray lightSerials = new JSONArray();
        int i = 0;
        while (i < serials.size()) {
            lightSerials.put(i, serials.get(i));
            ++i;
        }
        toSend.putOpt("deviceid", lightSerials);
        return toSend.toString();
    }

    public static /* bridge */ /* synthetic */ PHCLIPBuilder1_0 getInstance(int n) {
        return PHCLIPBuilder1_1.getInstance(n);
    }
}

