/*
 * Decompiled with CFR 0.152.
 */
package com.philips.lighting.hue.sdk.clip;

import com.philips.lighting.hue.sdk.clip.PHCLIPParser;
import com.philips.lighting.hue.sdk.clip.PHCLIPParser1_0;
import com.philips.lighting.hue.sdk.utilities.PHUtilities;
import com.philips.lighting.hue.sdk.utilities.impl.PHLog;
import com.philips.lighting.model.PHBridgeConfiguration;
import com.philips.lighting.model.PHScene;
import com.philips.lighting.model.PHSchedule;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class PHCLIPParser1_1
extends PHCLIPParser1_0
implements PHCLIPParser {
    public static PHCLIPParser1_1 getInstance(int key) {
        if (key == 4626 || key == 13364) {
            return new PHCLIPParser1_1();
        }
        return null;
    }

    @Override
    public PHBridgeConfiguration parseBridgeConfiguration(JSONObject rootObject) {
        PHBridgeConfiguration bridgeConfig = super.parseBridgeConfiguration(rootObject);
        JSONObject config = rootObject.optJSONObject("config");
        if (config == null) {
            config = rootObject;
        }
        if (config != null) {
            String timeZone = config.optString("timezone");
            String localTime = config.optString("localtime");
            if (bridgeConfig != null) {
                bridgeConfig.setTimeZone(timeZone);
                bridgeConfig.setLocalTime(localTime);
            }
        }
        return bridgeConfig;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<PHSchedule> parseSchedules(JSONObject rootObject) {
        block30: {
            schedulesList = new ArrayList<PHSchedule>();
            schedules = rootObject.optJSONObject("schedules");
            if (schedules == null) {
                schedules = rootObject;
            }
            if (schedules == null || (schedulesArray = schedules.names()) == null) break block30;
            i = 0;
            while (i < schedulesArray.length()) {
                block31: {
                    block32: {
                        block36: {
                            block35: {
                                block33: {
                                    block34: {
                                        scheduleIdentifier = schedulesArray.optString(i);
                                        scheduleObject = schedules.optJSONObject(scheduleIdentifier);
                                        if (scheduleObject == null) break block31;
                                        name = scheduleObject.optString("name");
                                        if (name == null || name.length() == 0) {
                                            this.errorMassage = "JSON is missing key: name";
                                            return null;
                                        }
                                        schedule = new PHSchedule(name);
                                        schedule.setIdentifier(scheduleIdentifier);
                                        description = scheduleObject.optString("description");
                                        schedule.setDescription(description);
                                        commandObject = scheduleObject.optJSONObject("command");
                                        if (commandObject != null) {
                                            commandKeysNeeded = new ArrayList<String>();
                                            commandKeysNeeded.add("address");
                                            commandKeysNeeded.add("body");
                                            commandKeysNeeded.add("method");
                                            keyIterator = commandObject.keys();
                                            keyCount = 0;
                                            while (keyIterator.hasNext()) {
                                                key = (String)keyIterator.next();
                                                if (!commandKeysNeeded.contains(key)) continue;
                                                commandKeysNeeded.remove(key);
                                                ++keyCount;
                                            }
                                            if (keyCount != 3) {
                                                missingKey = "";
                                                j = 0;
                                                while (j < commandKeysNeeded.size()) {
                                                    missingKey = String.valueOf(missingKey) + (String)commandKeysNeeded.get(j) + ",";
                                                    ++j;
                                                }
                                                missingKey = missingKey.substring(0, missingKey.length() - 1);
                                                this.errorMassage = "JSON is missing key : command(" + missingKey + ").";
                                                return null;
                                            }
                                            if (commandObject != null) {
                                                address = commandObject.optString("address");
                                                bodyObject = commandObject.optJSONObject("body");
                                                addressComponent = address.split("/");
                                                if (addressComponent.length > 4) {
                                                    if (addressComponent[3].equals("groups")) {
                                                        groupIdentifier = addressComponent[4];
                                                        schedule.setGroupIdentifier(groupIdentifier);
                                                    } else if (addressComponent[3].equals("lights")) {
                                                        lightIdentifier = addressComponent[4];
                                                        schedule.setLightIdentifier(lightIdentifier);
                                                    }
                                                }
                                                if (bodyObject != null) {
                                                    sceneIdentifier = bodyObject.optString("scene");
                                                    if (sceneIdentifier != null && sceneIdentifier.length() != 0) {
                                                        schedule.setSceneIdentifier(sceneIdentifier);
                                                    } else {
                                                        lightState = this.parseLightState(bodyObject);
                                                        if (lightState != null) {
                                                            schedule.setLightState(lightState);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        if ((created = scheduleObject.optString("created")) != null && created.length() > 0 && (createdDate = PHUtilities.stringToDate(created)) != null) {
                                            schedule.setCreated(createdDate);
                                        }
                                        time = scheduleObject.optString("time");
                                        localTime = scheduleObject.optString("localtime");
                                        if (localTime != null && localTime.length() > 0) {
                                            time = localTime;
                                            schedule.setLocalTime(true);
                                        }
                                        if (time == null || time.length() <= 0) break block32;
                                        weeklyRecurringIndicatorRange = time.indexOf(87);
                                        recurringIndicatorRange = time.indexOf(82);
                                        timeIndicatorRange = time.indexOf(84);
                                        timerIndicatorRange = time.indexOf("PT");
                                        randomIndicatorRange = time.indexOf(65);
                                        recurrence = 0;
                                        if (weeklyRecurringIndicatorRange == -1 || timeIndicatorRange == -1) break block33;
                                        recurrenceString = time.substring(1, timeIndicatorRange - 1);
                                        recurrence = Integer.parseInt(recurrenceString);
                                        schedule.setRecurringDays(recurrence);
                                        if (time.length() < timeIndicatorRange + 1 + 8) break block34;
                                        newTime = time.substring(timeIndicatorRange + 1, timeIndicatorRange + 1 + 8);
                                        date = PHUtilities.stringToDateForTime(newTime);
                                        if (date != null) {
                                            schedule.setDate(date);
                                        }
                                        break block35;
                                    }
                                    this.errorMassage = "JSON contains invalid data for time";
                                    return null;
                                }
                                if (recurringIndicatorRange == -1 || timeIndicatorRange == -1) ** GOTO lbl107
                                recurrenceString = time.substring(1, timeIndicatorRange - 2);
                                if (recurrenceString.length() == 0) {
                                    schedule.setRecurringTimerInterval(-1);
                                } else {
                                    recurrence = Integer.parseInt(recurrenceString);
                                    if (recurrence >= 0 && recurrence <= 99) {
                                        recurringTimerInterval = recurrence;
                                        schedule.setRecurringTimerInterval(recurringTimerInterval);
                                    } else {
                                        this.errorMassage = "JSON contains invalid data for time";
                                        return null;
lbl107:
                                        // 1 sources

                                        if (!time.contains("PT")) {
                                            date = null;
                                            date = time.length() > 19 ? PHUtilities.stringToDate(time.substring(0, 19)) : PHUtilities.stringToDate(time);
                                            if (date != null) {
                                                schedule.setDate(date);
                                            }
                                        }
                                    }
                                }
                            }
                            if (randomIndicatorRange == -1) break block36;
                            randomString = time.substring(randomIndicatorRange + 1);
                            if (randomString.length() != 8) ** GOTO lbl125
                            hours = Integer.parseInt(randomString.substring(0, 2));
                            minutes = Integer.parseInt(randomString.substring(3, 5));
                            seconds = Integer.parseInt(randomString.substring(6, 8));
                            if (hours <= 24 || minutes <= 60 || seconds <= 60) {
                                randomTime = hours * 3600 + minutes * 60 + seconds;
                                schedule.setRandomTime(randomTime);
                            } else {
                                this.errorMassage = "JSON contains invalid data for time";
                                return null;
lbl125:
                                // 1 sources

                                this.errorMassage = "JSON contains invalid data for time";
                                return null;
                            }
                        }
                        if (timerIndicatorRange == -1) break block32;
                        timerString = time.substring(timerIndicatorRange + 2);
                        if (timerString.length() > 8) {
                            timerString = timerString.substring(0, 8);
                        }
                        if (timerString.length() != 8) ** GOTO lbl141
                        hours = Integer.parseInt(timerString.substring(0, 2));
                        minutes = Integer.parseInt(timerString.substring(3, 5));
                        seconds = Integer.parseInt(timerString.substring(6, 8));
                        if (hours <= 24 || minutes <= 60 || seconds <= 60) {
                            schedule.setTimer(hours * 3600 + minutes * 60 + seconds);
                        } else {
                            this.errorMassage = "JSON contains invalid data for time";
                            return null;
lbl141:
                            // 1 sources

                            this.errorMassage = "JSON contains invalid data for time";
                            return null;
                        }
                    }
                    schedulesList.add(schedule);
                }
                ++i;
            }
        }
        return schedulesList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<PHScene> parseScene(JSONObject rootObject) {
        JSONObject scenes = rootObject.optJSONObject("scenes");
        if (scenes == null) {
            scenes = rootObject;
        }
        ArrayList<PHScene> list = new ArrayList<PHScene>();
        try {
            JSONArray arrays;
            if (scenes != null && (arrays = scenes.names()) != null) {
                int i = 0;
                while (i < arrays.length()) {
                    String identifier = arrays.optString(i);
                    if (identifier != null && (identifier.length() < 1 || identifier.length() > 16)) {
                        this.errorMassage = "JSON contains invalid scene identifier";
                        return null;
                    }
                    JSONObject obj = scenes.optJSONObject(identifier);
                    if (obj != null) {
                        String name = obj.optString("name");
                        if (name == null || name.length() == 0) {
                            this.errorMassage = "JSON is missing key: name";
                            return null;
                        }
                        Boolean activeState = null;
                        activeState = obj.isNull("active") ? null : Boolean.valueOf(obj.optBoolean("active"));
                        JSONArray lightsArray = obj.optJSONArray("lights");
                        if (lightsArray != null) {
                            String[] lightsIdentifier = new String[lightsArray.length()];
                            int lightcounter = 0;
                            while (lightcounter < lightsIdentifier.length) {
                                lightsIdentifier[lightcounter] = lightsArray.optString(lightcounter);
                                ++lightcounter;
                            }
                            PHScene scene = new PHScene();
                            scene.setSceneIdentifier(identifier);
                            scene.setName(name);
                            scene.setActiveState(this.chooseSceneActiveState(activeState));
                            scene.setLightIdentifiers(lightsIdentifier);
                            list.add(scene);
                        }
                    }
                    ++i;
                }
            }
            return list;
        }
        catch (Exception e) {
            if (PHLog.isLoggable()) {
                PHLog.e("PCCLIPParser1_1", "Excpetion: " + e);
                e.printStackTrace();
            }
            return null;
        }
    }

    private PHScene.PHSceneActiveState chooseSceneActiveState(Boolean activeState) {
        if (activeState == null) {
            return PHScene.PHSceneActiveState.SCENE_STATE_UNKNOWN;
        }
        if (activeState.booleanValue()) {
            return PHScene.PHSceneActiveState.SCENE_STATE_ACTIVE;
        }
        return PHScene.PHSceneActiveState.SCENE_STATE_INACTIVE;
    }

    public static /* bridge */ /* synthetic */ PHCLIPParser1_0 getInstance(int n) {
        return PHCLIPParser1_1.getInstance(n);
    }
}

